"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const body_parser_1 = __importDefault(require("body-parser"));
const cors_1 = __importDefault(require("cors"));
const path_1 = __importDefault(require("path"));
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
const mongoose_1 = __importDefault(require("mongoose"));
const routes_1 = __importDefault(require("./routes"));
const compression_1 = __importDefault(require("compression"));
const financa_1 = require("./util/financa");
const express_useragent_1 = __importDefault(require("express-useragent"));
const MONGODB_URI = `mongodb+srv://${process.env.MONGO_USER}:${process.env.MONGO_PASSWORD}@clustercnp.8weyjey.mongodb.net/${process.env.MONGO_DATABASE}?retryWrites=true&w=majority`;
const app = (0, express_1.default)();
const port = process.env.PORT || 8080;
app.use((0, compression_1.default)());
// app.use(morgan('combined', { stream: createWriteStream (
//   path.join(__dirname, 'access.log'),
//   { flags: 'a' }
// ) }));
app.use((0, cors_1.default)());
app.use('/images', express_1.default.static(path_1.default.join(__dirname, 'uploads')));
app.use(body_parser_1.default.json());
app.use(express_useragent_1.default.express());
app.use(routes_1.default);
app.get('/', (req, res, next) => {
    res.send('<h1>Bem vindo a ofa.cnp.ao</h1>');
});
// MiddleWare de Erro
app.use((error, req, res, next) => {
    if (!error.statusCode) {
        error.statusCode = 500;
    }
    res.status(error.statusCode).json({ message: error.message });
});
// Para remover aviso de deprecation
mongoose_1.default.set('strictQuery', false);
mongoose_1.default
    .connect(MONGODB_URI)
    .then((result) => {
    const server = app.listen(port, async () => {
        console.log(`
        🚀  Servidor rodando!
        🔉  Ouvindo na porta ${port}
        📭  Requisição em http://localhost:${port}
      `);
        setInterval(() => {
            (0, financa_1.checkReferences)();
            (0, financa_1.createAnnuallySF)();
            // checkMonthlySF(); Funcao para verificar se o usuario pagou a conta ou nao e depois desativar ou activar
            // sendPaymentNotification();
        }, 1000);
        // const io = socket.init(server);
    });
})
    .catch((err) => console.log(err));
