"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVotos = exports.createVoto = exports.searchVotante = exports.getCandidadto = exports.getCandidadtos = exports.createCandidadto = exports.confirmPresenca = exports.getInscricoes = exports.inscricaoCapfa = exports.inscricao = void 0;
const express_validator_1 = require("express-validator");
const aws_1 = require("../util/aws");
const pagination_1 = require("../util/pagination");
const assembleia_constitutiva_1 = __importDefault(require("../models/assembleia-constitutiva"));
const counter_1 = __importDefault(require("../models/counter"));
const evento_1 = __importDefault(require("../models/evento"));
const file_1 = require("../util/file");
const candidatosEleicao_1 = __importDefault(require("../models/candidatosEleicao"));
const main_1 = require("../util/main");
const voto_1 = __importDefault(require("../models/voto"));
const postmark_1 = __importDefault(require("../services/postmark"));
// Metodo para registar 
const inscricao = async (req, res, next) => {
    try {
        const { carteira, nome, genero, dataNascimento, estadoCivil, provincia, municipio, bairro, telefone1, telefone2, email, perfil, eventoId
        // Dados do secretario
        // userId,
         } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        let bi = req.body.bi;
        // const foto = req.file;
        // if (foto) {
        //   foto.filename = generateFileName(foto);
        // } else {
        //   const error: IError = new Error(`Por favor forneça uma foto!`);
        //   error.statusCode = 422;
        //   throw error;
        // }
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const evento = await evento_1.default.findById(eventoId);
        if (!evento) {
            const error = new Error(`Evento não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        const foundEmail = await assembleia_constitutiva_1.default.findOne({ email: email });
        if (foundEmail) {
            const error = new Error(`O email '${email}' já fez inscrição`);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(telefone1)) {
            const foundTel1 = await assembleia_constitutiva_1.default.findOne({ telefone1: telefone1 });
            if (foundTel1) {
                const error = new Error(`O número de telefone '${telefone1}' já fez inscrição`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(bi)) {
            bi = bi.toUpperCase();
            const foundBI = await assembleia_constitutiva_1.default.findOne({ bi: bi });
            if (foundBI) {
                const error = new Error(`O número do BI '${bi}' já fez inscrição!`);
                error.statusCode = 422;
                throw error;
            }
        }
        // Counter para gerar o numero de sequencia
        const counter = await counter_1.default.findOneAndUpdate({ id: 'assembleiaConstitutiva' }, { $inc: { seq: 1 } }, { new: true, upsert: true });
        const assembleiaConstitutiva = new assembleia_constitutiva_1.default({
            carteira,
            nome,
            genero,
            dataNascimento,
            estadoCivil,
            email,
            telefone1,
            provincia,
            bi,
            perfil: perfil,
            numero: counter.seq,
        });
        if (Boolean(telefone2)) {
            assembleiaConstitutiva.telefone2 = telefone2;
        }
        if (Boolean(bairro)) {
            assembleiaConstitutiva.bairro = bairro;
        }
        if (Boolean(municipio)) {
            assembleiaConstitutiva.municipio = municipio;
        }
        if (Boolean(municipio)) {
            assembleiaConstitutiva.municipio = municipio;
        }
        if (Boolean(bi)) {
            assembleiaConstitutiva.bi = bi;
        }
        if (Boolean(dataNascimento)) {
            assembleiaConstitutiva.dataNascimento = dataNascimento;
        }
        if (Boolean(estadoCivil)) {
            assembleiaConstitutiva.estadoCivil = estadoCivil;
        }
        await assembleiaConstitutiva.save();
        evento.inscricoes = evento.inscricoes + 1;
        await evento.save();
        if (Boolean(email)) {
            await postmark_1.default.sendEmail({
                To: email,
                From: process.env.SENDER_EMAIL,
                Subject: `Inscrição nº ${evento.inscricoes}`,
                HtmlBody: `<h1>Inscrição Realizada com sucesso</h1>
          <p>
             Parabéns as sua inscrição para participar da Assembleia Contitutiva foi realizada com sucesso.
          </p>

          <p>
            Inscrição nº ${evento.inscricoes}
          </p>
          
          <p><b>Nota:</b> Este e-mail foi gerado automaticamente pela plataforma </p>
        `,
                MessageStream: 'oubound'
            });
        }
        res.status(201).json({
            msg: 'Sucesso',
            assembleiaConstitutiva,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.inscricao = inscricao;
// Metodo para registar membros da CAPFA
const inscricaoCapfa = async (req, res, next) => {
    try {
        const { carteira, nome, genero, dataNascimento, estadoCivil, provincia, municipio, bairro, telefone1, telefone2, email, perfil, eventoId
        // Dados do secretario
        // userId,
         } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        let bi = req.body.bi;
        // Arquivo para upload
        const { copiaBI, diplomaCertificado, copiaReconhecimentoME } = req.files;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!copiaBI) {
            const error = new Error(`Faça o upload da cópia do BI!`);
            error.statusCode = 422;
            throw error;
        }
        if (!diplomaCertificado) {
            const error = new Error(`Faça o upload do certificado!`);
            error.statusCode = 422;
            throw error;
        }
        if (!copiaReconhecimentoME) {
            const error = new Error(`Faça o upload da Copia de Reconhecimento!`);
            error.statusCode = 422;
            throw error;
        }
        const evento = await evento_1.default.findById(eventoId);
        if (!evento) {
            const error = new Error(`Evento não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        const foundEmail = await assembleia_constitutiva_1.default.findOne({ email: email });
        if (foundEmail) {
            const error = new Error(`O email '${email}' já fez inscrição`);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(telefone1)) {
            const foundTel1 = await assembleia_constitutiva_1.default.findOne({ telefone1: telefone1 });
            if (foundTel1) {
                const error = new Error(`O número de telefone '${telefone1}' já fez inscrição`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(bi)) {
            bi = bi.toUpperCase();
            const foundBI = await assembleia_constitutiva_1.default.findOne({ bi: bi });
            if (foundBI) {
                const error = new Error(`O número do BI '${bi}' já fez inscrição!`);
                error.statusCode = 422;
                throw error;
            }
        }
        // Counter para gerar o numero de sequencia
        const counter = await counter_1.default.findOneAndUpdate({ id: 'assembleiaConstitutiva' }, { $inc: { seq: 1 } }, { new: true, upsert: true });
        // Renomeia os documentos
        copiaBI[0].filename = (0, file_1.generateFileName)(copiaBI[0]);
        diplomaCertificado[0].filename = (0, file_1.generateFileName)(diplomaCertificado[0]);
        copiaReconhecimentoME[0].filename = (0, file_1.generateFileName)(copiaReconhecimentoME[0]);
        const assembleiaConstitutiva = new assembleia_constitutiva_1.default({
            carteira,
            nome,
            genero,
            dataNascimento,
            estadoCivil,
            email,
            telefone1,
            provincia,
            bi,
            perfil: perfil,
            numero: counter.seq,
            docs: {
                copiaBI: copiaBI[0].filename,
                diplomaCertificado: diplomaCertificado[0].filename,
                copiaReconhecimentoME: copiaReconhecimentoME[0].filename,
            },
        });
        // Upload dos documentos
        await (0, aws_1.uploadFile)(copiaBI[0]);
        await (0, aws_1.uploadFile)(diplomaCertificado[0]);
        await (0, aws_1.uploadFile)(copiaReconhecimentoME[0]);
        if (Boolean(telefone2)) {
            assembleiaConstitutiva.telefone2 = telefone2;
        }
        if (Boolean(bairro)) {
            assembleiaConstitutiva.bairro = bairro;
        }
        if (Boolean(municipio)) {
            assembleiaConstitutiva.municipio = municipio;
        }
        if (Boolean(municipio)) {
            assembleiaConstitutiva.municipio = municipio;
        }
        if (Boolean(bi)) {
            assembleiaConstitutiva.bi = bi;
        }
        if (Boolean(dataNascimento)) {
            assembleiaConstitutiva.dataNascimento = dataNascimento;
        }
        if (Boolean(estadoCivil)) {
            assembleiaConstitutiva.estadoCivil = estadoCivil;
        }
        await assembleiaConstitutiva.save();
        evento.inscricoes = evento.inscricoes + 1;
        await evento.save();
        if (Boolean(email)) {
            await postmark_1.default.sendEmail({
                To: email,
                From: process.env.SENDER_EMAIL,
                Subject: `Inscrição nº ${evento.inscricoes}`,
                HtmlBody: `<h1>Inscrição Realizada com sucesso</h1>
          <p>
             Parabéns as sua inscrição para participar da Assembleia Contitutiva foi realizada com sucesso.
          </p>

          <p>
            Inscrição nº ${evento.inscricoes}
          </p>
          
          <p><b>Nota:</b> Este e-mail foi gerado automaticamente pela plataforma </p>
        `,
                MessageStream: 'outbound'
            });
        }
        res.status(201).json({
            msg: 'Sucesso',
            assembleiaConstitutiva,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.inscricaoCapfa = inscricaoCapfa;
// Funcao que busca todas inscricoes
const getInscricoes = async (req, res, next) => {
    try {
        const { status, funcao, delegacao } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filter = {};
        if (Boolean(status)) {
            filter.status = status;
        }
        if (Boolean(funcao)) {
            filter.funcao = funcao;
        }
        const total = await assembleia_constitutiva_1.default.find(filter).count();
        const inscricoes = await assembleia_constitutiva_1.default.find(filter)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage);
        res.status(200).json({
            msg: 'Sucesso',
            inscricoes,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getInscricoes = getInscricoes;
const confirmPresenca = async (req, res, next) => {
    try {
        const { id } = req.params;
        const assembleiaConstitutiva = await assembleia_constitutiva_1.default.findById(id);
        if (!assembleiaConstitutiva) {
            const error = new Error(`Participante não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        assembleiaConstitutiva.presenca = !assembleiaConstitutiva.presenca;
        await assembleiaConstitutiva.save();
        res.status(200).json({ msg: 'Sucesso', assembleiaConstitutiva });
    }
    catch (err) {
        next(err);
    }
};
exports.confirmPresenca = confirmPresenca;
// FUCIONALIDADES DE CANDIDATOS AS ELEICOES
// Controller para criar Candidato
const createCandidadto = async (req, res, next) => {
    try {
        let { nome, lista, evento, userId, } = req.body;
        const imagem = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        // const admin = await User.findById(userId);
        // if (!admin) {
        //   const error: IError = new Error('Admin não encontrado!');
        //   error.statusCode = 422;
        //   throw error;
        // }
        if (imagem) {
            imagem.filename = (0, file_1.generateFileName)(imagem);
        }
        const cantidado = new candidatosEleicao_1.default({
            nome,
            lista,
            evento,
            votos: 0,
            admin: userId,
        });
        if (imagem) {
            cantidado.imagem = imagem.filename;
        }
        await cantidado.save();
        if (imagem) {
            await (0, aws_1.uploadFile)(imagem);
        }
        // HistoricoActividade
        // if (admin) { 
        //   await createHistoricoActividade(
        //     `inscreveu um candidato para eleiçōes`,
        //     'candidatosEleicao',
        //     cantidado.id,
        //     admin,
        //   );
        // }
        res.status(201).json({ msg: 'Sucesso', cantidado });
    }
    catch (err) {
        next(err);
    }
};
exports.createCandidadto = createCandidadto;
// Metodo que busca todos os Candidatos
const getCandidadtos = async (req, res, next) => {
    try {
        const { status } = req.query;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(status)) {
            filterObj.status = status;
        }
        const total = await candidatosEleicao_1.default.find(filterObj).count();
        const candidatosEleicao = await candidatosEleicao_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .sort((0, main_1.sortBy)(req.query.sortBy || 'createdAt:DESC'));
        for (const candidatoEleicao of candidatosEleicao) {
            if (candidatoEleicao.imagem) {
                candidatoEleicao.imagem = await (0, aws_1.getURL)(candidatoEleicao.imagem);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            candidatosEleicao,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getCandidadtos = getCandidadtos;
// Metodo que busca pelo id candidato
const getCandidadto = async (req, res, next) => {
    try {
        const { id } = req.params;
        const candidatoEleicao = await candidatosEleicao_1.default.findById(id);
        if (!candidatoEleicao) {
            const error = new Error('Candidato não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (candidatoEleicao.imagem) {
            candidatoEleicao.imagem = await (0, aws_1.getURL)(candidatoEleicao.imagem);
        }
        res.status(200).json({
            msg: 'Sucesso',
            candidatoEleicao,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getCandidadto = getCandidadto;
// FUCIONALIDADES DE VOTOS
const searchVotante = async (req, res, next) => {
    // let { bi } = req.body;
    let bi = req.body.bi;
    bi = bi.toUpperCase();
    try {
        const votante = await assembleia_constitutiva_1.default.findOne({ bi });
        if (!votante) {
            const error = new Error(`Votante não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({
            msg: 'Sucesso',
            votante,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.searchVotante = searchVotante;
// Controller para criar voto
const createVoto = async (req, res, next) => {
    try {
        let { votante, candidato, evento } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const verifyEvento = await evento_1.default.findById(evento);
        if (!verifyEvento) {
            const error = new Error('Evento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const verifyCandidadto = await candidatosEleicao_1.default.findById(candidato);
        if (!verifyCandidadto) {
            const error = new Error('Candidato não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const verifyVotante = await assembleia_constitutiva_1.default.findById(votante);
        if (!verifyVotante) {
            const error = new Error('Votante não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const verifyVotanteVotou = await voto_1.default.findOne({ votante });
        if (verifyVotanteVotou) {
            const error = new Error('Caro votante não lhe é permitido votar mais de uma vez.!');
            error.statusCode = 422;
            throw error;
        }
        const voto = new voto_1.default({
            votante,
            candidato,
            evento,
        });
        verifyCandidadto.votos = verifyCandidadto.votos + 1;
        voto.save();
        verifyCandidadto.save();
        res.status(201).json({ msg: 'Sucesso', voto });
    }
    catch (err) {
        next(err);
    }
};
exports.createVoto = createVoto;
// Metodo que busca todos os votos
const getVotos = async (req, res, next) => {
    try {
        const { status } = req.query;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(status)) {
            filterObj.status = status;
        }
        const total = await voto_1.default.find(filterObj).count();
        const votos = await voto_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'votante',
        })
            .populate({
            path: 'candidato',
        });
        res.status(200).json({
            msg: 'Sucesso',
            votos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getVotos = getVotos;
