"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.editFoto = exports.editDadosPessoais = void 0;
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const user_1 = __importDefault(require("../models/user"));
const aws_1 = require("../util/aws");
const file_1 = require("../util/file");
const express_validator_1 = require("express-validator");
const user_2 = __importDefault(require("../models/user"));
const membro_1 = __importDefault(require("../models/membro"));
const main_1 = require("../util/main");
const editDadosPessoais = async (req, res, next) => {
    try {
        let { nome, genero, dataNascimento, dataEmissaoBi, estadoCivil, provincia, municipio, bairro, rua, provinciaNasc, municipioNasc, nacionalidade, nomePai, nomeMae, telefone1, telefone2, email, campanha, dadosPessoaisId, userId, } = req.body;
        let bi = req.body.bi;
        if (bi)
            bi = bi.toUpperCase();
        let user;
        let userAdmin;
        let admin;
        console.log(req.body);
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
        if (Boolean(userId)) {
            admin = await user_2.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrados!');
                error.statusCode = 422;
                throw error;
            }
        }
        if (!dadosPessoais) {
            const error = new Error('Dados pessoais não encontrados!');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(email)) {
            const foundEmail = await dados_pessoais_1.default.findOne({
                email: email,
                _id: { $ne: dadosPessoaisId },
            });
            const foundUserAdminEmail = await user_2.default.findOne({
                email: email,
                dadosPessoais: { $ne: dadosPessoais.id },
            });
            if ((foundEmail || foundUserAdminEmail) && email !== '') {
                const error = new Error(`O email ${email} já está sendo usado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        const membro = await membro_1.default.findOne({ dadosPessoais: dadosPessoaisId });
        if (membro) {
            const foundUserEmail = await user_1.default.findOne({
                email: email,
                membro: { $ne: membro.id },
            });
            if (foundUserEmail) {
                const error = new Error(`O email ${email} já está sendo usado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(telefone1)) {
            const foundTel1 = await dados_pessoais_1.default.find({
                telefone1: telefone1,
                _id: { $ne: dadosPessoaisId },
            });
            if (foundTel1.length > 0) {
                const error = new Error(`O telefone1 ${telefone1} já está sendo usado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(bi)) {
            const foundBI = await dados_pessoais_1.default.find({
                bi: bi,
                _id: { $ne: dadosPessoaisId },
            });
            if (foundBI.length > 0) {
                const error = new Error(`O BI ${bi} já está sendo usado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(campanha) && JSON.parse(campanha)) {
            // if (membro) {
            //   membro.campanha = true;
            //   membro.dataCampanha = new Date();
            //   await membro.save();
            // }
            if (!Boolean(email) && dadosPessoais.email === '') {
                const error = new Error(`O campo email é obrigatório!`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(nome)) {
            dadosPessoais.nome = nome;
            if (membro) {
                membro.nome = dadosPessoais.nome;
            }
        }
        if (Boolean(genero)) {
            dadosPessoais.genero = genero;
        }
        if (Boolean(dataNascimento)) {
            dadosPessoais.dataNascimento = dataNascimento;
        }
        if (Boolean(estadoCivil)) {
            dadosPessoais.estadoCivil = estadoCivil;
        }
        if (Boolean(provincia)) {
            dadosPessoais.provincia = provincia;
        }
        if (Boolean(municipio)) {
            dadosPessoais.municipio = municipio;
        }
        if (Boolean(bairro)) {
            dadosPessoais.bairro = bairro;
        }
        if (Boolean(rua)) {
            dadosPessoais.rua = rua;
        }
        if (Boolean(provinciaNasc)) {
            dadosPessoais.provinciaNasc = provinciaNasc;
        }
        if (Boolean(municipioNasc)) {
            dadosPessoais.municipioNasc = municipioNasc;
        }
        if (Boolean(nacionalidade)) {
            dadosPessoais.nacionalidade = nacionalidade;
        }
        if (Boolean(nomePai)) {
            dadosPessoais.nomePai = nomePai;
        }
        if (Boolean(nomeMae)) {
            dadosPessoais.nomeMae = nomeMae;
        }
        if (Boolean(telefone1)) {
            dadosPessoais.telefone1 = telefone1;
        }
        if (Boolean(telefone2)) {
            dadosPessoais.telefone2 = telefone2;
        }
        if (Boolean(dataEmissaoBi)) {
            dadosPessoais.bi = bi;
        }
        if (Boolean(dataEmissaoBi)) {
            dadosPessoais.dataEmissaoBi = dataEmissaoBi;
        }
        if (Boolean(email)) {
            user = await user_1.default.findOne({ membro: membro === null || membro === void 0 ? void 0 : membro.id });
            if (user) {
                user.email = email;
                await user.save();
            }
            userAdmin = await user_2.default.findOne({
                dadosPessoais: dadosPessoais.id,
            });
            if (userAdmin) {
                userAdmin.email = email;
                await userAdmin.save();
            }
            dadosPessoais.email = email;
        }
        await dadosPessoais.save();
        let action = 'Editou DadosPessoais';
        if (admin) {
            await (0, main_1.createHistoricoActividade)(action, 'DadosPessoais', dadosPessoais.id, admin);
        }
        res.status(201).json({
            msg: 'Editado com sucesso!',
            dadosPessoais,
            user,
            userAdmin,
            membro,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.editDadosPessoais = editDadosPessoais;
const editFoto = async (req, res, next) => {
    try {
        const { dadosPessoaisId, userId } = req.body;
        const foto = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        let admin;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!foto) {
            const error = new Error('Por favor fornceça uma foto');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_2.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrados!');
                error.statusCode = 422;
                throw error;
            }
        }
        const dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
        if (!dadosPessoais) {
            const error = new Error('Dados pessoais não encontrados!');
            error.statusCode = 422;
            throw error;
        }
        // Depois renomeia e faz o upload
        foto.filename = (0, file_1.generateFileName)(foto);
        await (0, aws_1.uploadFile)(foto);
        dadosPessoais.fotoURL = foto.filename;
        const newDadosPessoais = await dadosPessoais.save();
        newDadosPessoais.fotoURL = await (0, aws_1.getURL)(newDadosPessoais.fotoURL);
        let action = 'Editou Foto';
        if (admin) {
            await (0, main_1.createHistoricoActividade)(action, 'DadosPessoais', dadosPessoais.id, admin);
        }
        res.status(201).json({
            msg: 'Editado com sucesso!',
            dadosPessoais: newDadosPessoais,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.editFoto = editFoto;
