"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteDocUpload = exports.changeImage = exports.editDocUpload = exports.getDocUpload = exports.getDocsUpload = exports.createDoc = void 0;
const express_validator_1 = require("express-validator");
const file_1 = require("../util/file");
const aws_1 = require("../util/aws");
const user_1 = __importDefault(require("../models/user"));
const pagination_1 = require("../util/pagination");
const main_1 = require("../util/main");
const docs_uploads_1 = __importDefault(require("../models/docs-uploads"));
// Controller para criar doc
const createDoc = async (req, res, next) => {
    try {
        let { tipoFile, nomeFile, descricao, userId, } = req.body;
        const anexo = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        // if (!anexo) {
        //   const error: IError = new Error('Por favo, carregue um documento!');
        //   error.statusCode = 422;
        //   throw error;
        // }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (anexo) {
            anexo.filename = (0, file_1.generateFileName)(anexo);
        }
        const docsUpload = new docs_uploads_1.default({
            tipoFile,
            nomeFile,
            descricao,
            // anexo: anexo.filename,
            admin: userId,
        });
        if (anexo) {
            docsUpload.anexo = anexo.filename;
        }
        await docsUpload.save();
        if (anexo) {
            await (0, aws_1.uploadFile)(anexo);
        }
        // HistoricoActividade
        await (0, main_1.createHistoricoActividade)(`inseriu um documento no docsUpload`, 'docsUpload', docsUpload.id, admin);
        // docsUpload.anexo = await getURL(docsUpload.anexo);
        res.status(201).json({ msg: 'Sucesso', docsUpload });
    }
    catch (err) {
        next(err);
    }
};
exports.createDoc = createDoc;
// Metodo que busca todos os docs
const getDocsUpload = async (req, res, next) => {
    try {
        const { status, tipoFile } = req.query;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(tipoFile)) {
            filterObj.tipoFile = tipoFile;
        }
        if (Boolean(status)) {
            filterObj.status = status;
        }
        const total = await docs_uploads_1.default.find(filterObj).count();
        const docsUpload = await docs_uploads_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .sort({ dataDespacho: -1 });
        for (const docUpload of docsUpload) {
            if (docUpload.anexo) {
                docUpload.anexo = await (0, aws_1.getURL)(docUpload.anexo);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            docsUpload,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getDocsUpload = getDocsUpload;
// Metodo que busca pelo id docUpload
const getDocUpload = async (req, res, next) => {
    try {
        const { id } = req.params;
        const docUpload = await docs_uploads_1.default.findById(id);
        if (!docUpload) {
            const error = new Error('Documento não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (docUpload.anexo) {
            docUpload.anexo = await (0, aws_1.getURL)(docUpload.anexo);
        }
        res.status(200).json({
            msg: 'Sucesso',
            docUpload,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getDocUpload = getDocUpload;
// Controller para editar docUpload
const editDocUpload = async (req, res, next) => {
    try {
        let { docUploadId, tipoFile, nomeFile, descricao, status, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const docUpload = await docs_uploads_1.default.findById(docUploadId);
        if (!docUpload) {
            const error = new Error('Doc não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(tipoFile)) {
            docUpload.tipoFile = tipoFile;
        }
        if (Boolean(nomeFile)) {
            docUpload.nomeFile = nomeFile;
        }
        if (Boolean(descricao)) {
            docUpload.descricao = descricao;
        }
        if (Boolean(status)) {
            docUpload.status = status;
            docUpload.dataDespacho = new Date();
        }
        await docUpload.save();
        // HistoricoActividade
        await (0, main_1.createHistoricoActividade)(`Editou docUpload`, 'docUpload', docUpload.id, admin);
        if (docUpload.anexo) {
            docUpload.anexo = await (0, aws_1.getURL)(docUpload.anexo);
        }
        res.status(201).json({ msg: 'Sucesso', docUpload });
    }
    catch (err) {
        next(err);
    }
};
exports.editDocUpload = editDocUpload;
const changeImage = async (req, res, next) => {
    try {
        const { docUploadId, userId } = req.body;
        const anexo = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (!anexo) {
            const error = new Error('Por favor fornceça um documento');
            error.statusCode = 422;
            throw error;
        }
        const docUpload = await docs_uploads_1.default.findById(docUploadId);
        if (!docUpload) {
            const error = new Error('Documento não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        // Depois renomeia e faz o upload
        anexo.filename = (0, file_1.generateFileName)(anexo);
        await (0, aws_1.uploadFile)(anexo);
        docUpload.anexo = anexo.filename;
        await docUpload.save();
        // HistoricoActividade
        await (0, main_1.createHistoricoActividade)(`Alterou imagem do docUpload`, 'docUpload', docUpload.id, admin);
        docUpload.anexo = await (0, aws_1.getURL)(docUpload.anexo);
        res.status(201).json({
            msg: 'Sucesso!',
            docUpload,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.changeImage = changeImage;
const deleteDocUpload = async (req, res, next) => {
    try {
        const { id, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findOne({ _id: userId, isAdmin: true });
        if (!user) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const docUpload = await docs_uploads_1.default.findById(id);
        if (!docUpload) {
            const error = new Error('Documento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        await docUpload.delete();
        await (0, main_1.createHistoricoActividade)(`Deletou docUpload: ${docUpload.nomeFile}`, 'docUpload', docUpload.id, user);
        res.status(204).json({ msg: 'Sucesso!' });
    }
    catch (err) {
        next(err);
    }
};
exports.deleteDocUpload = deleteDocUpload;
