"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteLei = exports.editLei = exports.getLei = exports.searchLeiByNumero = exports.getLeis = exports.registerLei = void 0;
const lei_1 = __importDefault(require("../models/lei"));
const express_validator_1 = require("express-validator");
// Funcao Para registar lei
const registerLei = async (req, res, next) => {
    try {
        let { titulo, numero } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const foundLei = await lei_1.default.findOne({ numero: numero });
        if (foundLei) {
            const error = new Error(`Lei nº ${numero} já existe!`);
            error.statusCode = 422;
            throw error;
        }
        const lei = new lei_1.default({
            titulo,
            numero
        });
        await lei.save();
        res.status(201).json({ msg: 'Sucesso', lei });
    }
    catch (err) {
        next(err);
    }
};
exports.registerLei = registerLei;
// Funcao Para pegar todas as leis
const getLeis = async (req, res, next) => {
    try {
        const leis = await lei_1.default.find()
            .sort({ numero: 1 });
        res.status(200).json({ msg: "Sucesso", leis: leis });
    }
    catch (err) {
        next(err);
    }
};
exports.getLeis = getLeis;
// Funcao para pesquisar lei por e numero
const searchLeiByNumero = async (req, res, next) => {
    try {
        const { numero } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const lei = await lei_1.default.findOne({ numero: numero });
        if (!lei) {
            const error = new Error('Lei não encontrada');
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({ msg: "Sucesso", lei });
    }
    catch (err) {
        next(err);
    }
};
exports.searchLeiByNumero = searchLeiByNumero;
// Funcao que pega uma lei
const getLei = async (req, res, next) => {
    try {
        const { id } = req.params;
        const lei = await lei_1.default.findById(id);
        if (!lei) {
            const error = new Error('Lei não encontrada');
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({ msg: "Sucesso", lei: lei });
    }
    catch (err) {
        next(err);
    }
};
exports.getLei = getLei;
// Metodo que actualiza lei
const editLei = async (req, res, next) => {
    try {
        const { leiId, titulo } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const lei = await lei_1.default.findById(leiId);
        if (!lei) {
            const error = new Error('Lei não encontrada');
            error.statusCode = 422;
            throw error;
        }
        lei.titulo = titulo;
        await lei.save();
        res.status(201).json({ msg: "Sucesso", lei });
    }
    catch (err) {
        next(err);
    }
};
exports.editLei = editLei;
// Metodo para deletar lei
const deleteLei = async (req, res, next) => {
    try {
        const { leiId, titulo } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const lei = await lei_1.default.findById(leiId);
        if (!lei) {
            const error = new Error('Lei não encontrada');
            error.statusCode = 422;
            throw error;
        }
        await lei.delete();
        res.status(204).json({ msg: "Sucesso", lei });
    }
    catch (err) {
        next(err);
    }
};
exports.deleteLei = deleteLei;
