"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deletePainel = exports.getOnePainel = exports.getAllPaineis = exports.createPainel = void 0;
const express_validator_1 = require("express-validator");
const painel_1 = __importDefault(require("../models/painel"));
const mongoose_1 = __importDefault(require("mongoose"));
const createPainel = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const { nome } = req.body;
        const verifyPainel = await painel_1.default.findOne({ nome });
        if (verifyPainel) {
            const error = new Error(`O painel ${verifyPainel.nome} já foi criado! `);
            error.statusCode = 422;
            throw error;
        }
        const painel = new painel_1.default({
            nome
        });
        await painel.save();
        res.status(201).json({
            msg: 'Painel criado com sucesso',
            painel
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createPainel = createPainel;
const getAllPaineis = async (req, res, next) => {
    try {
        try {
            const paineis = await painel_1.default.find({});
            if (paineis.length === 0) {
                return res.status(404).json({
                    success: false,
                    paineis
                });
            }
            res.status(200).json({
                success: true,
                paineis
            });
        }
        catch (err) {
            next(err);
        }
    }
    catch (err) {
        next(err);
    }
};
exports.getAllPaineis = getAllPaineis;
const getOnePainel = async (req, res, next) => {
    try {
        const id = req.params.id;
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (validId) {
            const painel = await painel_1.default.findOne({ _id: id });
            if (!painel) {
                return res.status(404).json({
                    success: false,
                    painel
                });
            }
            res.status(200).json({
                success: true,
                painel
            });
        }
        else {
            return res.status(400).json({
                success: false,
                message: 'Id inválido.'
            });
        }
    }
    catch (err) {
        next(err);
    }
};
exports.getOnePainel = getOnePainel;
const deletePainel = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const id = req.params.id;
        // Verifica se o id é válido
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (!validId) {
            return res.status(400).json({
                success: false,
                message: 'ID inválido.',
            });
        }
        // Busca o painel para garantir que ele existe
        const painel = await painel_1.default.findById(id);
        if (!painel) {
            return res.status(404).json({
                success: false,
                message: 'Painel não encontrado.',
            });
        }
        // Deleta o painel
        await painel_1.default.findByIdAndDelete(id);
        res.status(200).json({
            success: true,
            message: `Painel ${painel.nome} deletado com sucesso.`,
        });
    }
    catch (err) {
        next(err); // Passa o erro para o middleware de erro
    }
};
exports.deletePainel = deletePainel;
