"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.agendaStatus = void 0;
const mongoose_1 = require("mongoose");
exports.agendaStatus = ['Disponivel', 'Indisponivel'];
const AgendaSchema = new mongoose_1.Schema({
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
    diaDaSemana: {
        type: String,
    },
    dia: {
        type: Number,
    },
    mes: {
        type: Number,
    },
    ano: {
        type: Number,
    },
    horaInicio: {
        type: Number,
    },
    minutoInicio: {
        type: Number,
    },
    horaTermino: {
        type: Number,
    },
    minutoTermino: {
        type: Number,
    },
    status: {
        type: String,
        enum: exports.agendaStatus,
        default: 'Disponivel'
    },
    agendamento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Agendamento',
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
}, { timestamps: true });
const Agenda = (0, mongoose_1.model)('Agenda', AgendaSchema);
exports.default = Agenda;
