"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const categoriaSchema = new mongoose_1.Schema({
    nome: {
        type: String,
        required: true
    },
    // Referência à categoria pai (caso exista)
    pai: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Categoria',
        default: null
    },
    // Array de subcategorias
    subcategorias: [{
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Categoria'
        }],
    descricao: {
        type: String,
    },
}, { timestamps: true });
const Categoria = (0, mongoose_1.model)('Categoria', categoriaSchema);
exports.default = Categoria;
