"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const descricaoArtigoSchema = new mongoose_1.Schema({
    numero: {
        type: Number,
        required: true,
    },
    descricao: {
        type: String,
        required: true,
    },
    artigo: {
        type: mongoose_1.Schema.Types.ObjectId,
        required: true,
        ref: 'Artigo',
    },
}, { timestamps: true });
const DescricaoArtigo = (0, mongoose_1.model)('DescricaoArtigo', descricaoArtigoSchema);
exports.default = DescricaoArtigo;
