"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.expedienteGeralStatus = void 0;
const mongoose_1 = require("mongoose");
exports.expedienteGeralStatus = [
    'Análise',
    'Analisado-Secretaria',
    'Analisado-AT',
    'Concluído',
];
const expedienteSchema = new mongoose_1.Schema({
    nome: String,
    email: String,
    tel: String,
    funcao: String,
    departamento: String,
    instituicao: String,
    assunto: String,
    descricao: String,
    anexo1: String,
    anexo2: String,
    numero: Number,
    dataDespacho: String,
    despachadoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    status: {
        type: String,
        enum: exports.expedienteGeralStatus,
        default: 'Análise',
    },
    respostas: [
        {
            admin: {
                type: mongoose_1.Schema.Types.ObjectId,
                ref: 'UserAdmin',
            },
            content: {
                type: String
            },
            data: {
                type: Date
            }
        },
    ],
}, { timestamps: true });
const ExpedienteGeral = (0, mongoose_1.model)('ExpedienteGeral', expedienteSchema);
exports.default = ExpedienteGeral;
