"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.historicoLoginAdminActions = void 0;
const mongoose_1 = require("mongoose");
exports.historicoLoginAdminActions = ['Login', 'Logout'];
const historicoLoginAdminSchema = new mongoose_1.Schema({
    action: {
        type: String,
        enum: exports.historicoLoginAdminActions,
    },
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    device: {
        browser: String,
        version: String,
        os: String,
        platform: String,
        source: String,
        isMobile: Boolean,
        isDesktop: Boolean,
        isBot: String,
    },
    cnp: {
        type: Boolean
    },
}, { timestamps: true });
const HistoricoLoginAdmin = (0, mongoose_1.model)('HistoricoLoginAdmin', historicoLoginAdminSchema);
exports.default = HistoricoLoginAdmin;
