"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.historicoLoginMembroWebActions = void 0;
const mongoose_1 = require("mongoose");
exports.historicoLoginMembroWebActions = ['Login', 'Logout'];
const historicoLoginMembroWebSchema = new mongoose_1.Schema({
    action: {
        type: String,
        enum: exports.historicoLoginMembroWebActions,
    },
    user: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User',
    },
    device: {
        browser: String,
        version: String,
        os: String,
        platform: String,
        source: String,
        isMobile: Boolean,
        isDesktop: Boolean,
        isBot: String,
    },
    cnp: {
        type: Boolean
    },
    onApp: {
        type: Boolean
    }
}, { timestamps: true });
const HistoricoLoginMembroWeb = (0, mongoose_1.model)('HistoricoLoginMembroWeb', historicoLoginMembroWebSchema);
exports.default = HistoricoLoginMembroWeb;
