"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const inqueritoSchema = new mongoose_1.Schema({
    nome: {
        type: String,
        required: true,
    },
    evento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Evento', // Referencia ao Evento
        required: true,
    },
    perguntas: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Pergunta', // Relacionamento com as perguntas
        }
    ],
    participantes: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Participante', // Relacionamento com os Participantes
        }
    ],
}, { timestamps: true });
inqueritoSchema.index({ nome: 1 }, { unique: true }); // Índice único para o nome
const Inquerito = (0, mongoose_1.model)('Inquerito', inqueritoSchema);
exports.default = Inquerito;
