"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const medicamentoSchema = new mongoose_1.Schema({
    nomeGenerico: {
        type: String,
        required: true
    },
    codNacional: {
        type: String,
        required: true
    },
    codUNSPSC: {
        type: String,
        required: true
    },
    apresentacao: {
        type: String,
        required: true
    },
    categoria: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Categoria',
        required: true
    },
    restricoes: [{
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Restricao'
        }],
}, { timestamps: true });
const Medicamento = (0, mongoose_1.model)('Medicamento', medicamentoSchema);
exports.default = Medicamento;
