"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const mesaRedondaShema = new mongoose_1.Schema({
    evento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Evento',
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
    numeroCarteira: {
        type: String,
    },
    nome: {
        type: String,
    },
    dataNascimento: {
        type: Date,
    },
    genero: {
        type: String,
    },
    profissao: {
        type: String,
    },
    localTrabalho: {
        type: String,
    },
    email: {
        type: String,
    },
    tel: {
        type: String,
    },
    numero: {
        type: Number,
    },
    presenca: {
        type: Boolean,
    },
}, { timestamps: true });
const MesaRedonda = (0, mongoose_1.model)('MesaRedonda', mesaRedondaShema);
exports.default = MesaRedonda;
