"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const MessageSchema = new mongoose_1.Schema({
    sender: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais',
    },
    receiver: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais',
    },
    content: {
        type: String
    },
    chat: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Chat',
    },
    viewed: {
        type: Boolean,
        default: false
    },
    withAdmin: {
        type: Boolean
    },
}, { timestamps: true });
const Message = (0, mongoose_1.model)('Message', MessageSchema);
exports.default = Message;
