"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const noticiaSchema = new mongoose_1.Schema({
    titulo: {
        type: String,
    },
    subTitulo: {
        type: String,
    },
    imagem: {
        type: String,
    },
    conteudo: String,
    fonte: {
        type: String,
    },
    link: {
        type: String,
    },
    destaque: {
        type: Boolean
    },
    categoria: {
        type: String
    },
    status: {
        type: String,
        enum: ['Activo', 'Inactivo'],
        default: 'Activo'
    },
    ordem: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Ordem',
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
}, { timestamps: true });
const Noticia = (0, mongoose_1.model)('Noticia', noticiaSchema);
exports.default = Noticia;
