"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const perguntaSchema = new mongoose_1.Schema({
    texto: {
        type: String,
        required: true,
    },
    inquerito: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Inquerito', // Relaciona a pergunta ao Inquérito
        required: true,
    },
    respostas: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Resposta', // Relaciona as respostas a essa pergunta
        }
    ],
}, { timestamps: true });
perguntaSchema.index({ inquerito: 1 }); // Índice para melhorar a consulta
const Pergunta = (0, mongoose_1.model)('Pergunta', perguntaSchema);
exports.default = Pergunta;
