"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.saidaTipo = void 0;
const mongoose_1 = require("mongoose");
exports.saidaTipo = ['Salário', 'Outro'];
const saidaSchema = new mongoose_1.Schema({
    valor: {
        type: String,
    },
    descricao: {
        type: String,
    },
    tipo: {
        type: String,
        enum: exports.saidaTipo
    },
    funcionario: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
}, { timestamps: true });
const Saida = (0, mongoose_1.model)('Saida', saidaSchema);
exports.default = Saida;
