"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserStatus = void 0;
const mongoose_1 = require("mongoose");
exports.UserStatus = ['Activo', 'Inactivo'];
const UserSchema = new mongoose_1.Schema({
    email: {
        type: String,
    },
    password: {
        type: String,
    },
    funcao: {
        type: String,
    },
    delegacao: {
        type: String,
    },
    codigoVerificao: {
        type: Number,
    },
    dataCV: {
        type: Date,
    },
    status: {
        type: String,
        enum: exports.UserStatus,
        default: 'Activo'
    },
    dadosPessoais: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais'
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro'
    },
    tipo: {
        type: String,
        enum: ['Membro', 'Admin'],
        default: 'Membro'
    },
    isAdmin: {
        type: Boolean,
    },
    direccao: {
        type: String,
        enum: ['OFA', 'CAPFA'],
    },
    assinatura: {
        type: String
    },
    carimbo: {
        type: String
    },
}, { timestamps: true });
const User = (0, mongoose_1.model)('User', UserSchema);
exports.default = User;
