"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const authController = __importStar(require("../controllers/auth"));
const express_1 = require("express");
const schemas = __importStar(require("./validation-schemas"));
const router = (0, express_1.Router)();
router.post('/auth/login', schemas.login, authController.login);
router.post('/auth/login-admin', schemas.login, authController.login);
router.post('/auth/login-membro', schemas.loginMembro, authController.loginMembro);
router.post('/auth/login-membro-mobile', schemas.loginMembroMobile, authController.loginMembroMobile);
router.post('/auth/is-logged', schemas.isLoggedSchema, authController.isLogged);
// Remover
router.post('/auth/is-logged-admin', schemas.isLoggedSchema, authController.isLogged);
router.post('/auth/is-logged-membro', schemas.isLoggedSchema, authController.isLogged);
// Fim Remover
router.post('/auth/request-verification-code', schemas.requestVerificationCode, authController.requestVerificationCode);
router.post('/auth/check-verification-code', schemas.checkVerificationCode, authController.checkVerificationCode);
router.patch('/auth/edit-password', schemas.editPassword, authController.editPassword);
router.get('/auth/historico-admins', authController.getHistoricoLoginAdmins);
router.get('/auth/historico-admin/:id', authController.getHistoricoLoginAdmin);
router.get('/auth/historico-membros', authController.getHistoricoLoginMembros);
router.get('/auth/historico-membro/:id', authController.getHistoricoLoginMembro);
router.post('/auth/refresh-token', schemas.authRefreshToken, authController.refreshToken);
exports.default = router;
