"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.experienciaProfissionalCreate = exports.siteInfoChangeImage = exports.siteInfoEdit = exports.siteInfoCreate = exports.carouselChangeImage = exports.carouselEdit = exports.carouselCreate = exports.approveSolicitacaoByPresidente = exports.approveSolicitacaoBySecretaria = exports.searchSolicitacaoByNumber = exports.createSolicitacao = exports.feedbackDelete = exports.feedbackSend = exports.messageView = exports.sendMessageMembroToAdmin = exports.sendMessageAdminToMembro = exports.authRefreshToken = exports.loginMembroMobile = exports.checkVerificationCode = exports.requestVerificationCode = exports.editPassword = exports.isLoggedSchema = exports.loginMembro = exports.login = exports.dadosPessoaisEdit = exports.changeFuncinarioStatus = exports.makeMembroAdmin = exports.createUserAdmin = exports.createEmolumento = exports.createAgendamento = exports.deleteAgenda = exports.createAgenda = exports.solicitacaoChangeStatus = exports.solicitacaoRegister = exports.emailPosmarkSend = exports.emailSend = exports.membroActualizacaoDados = exports.verifyBi = exports.membroEditDoc = exports.membroApproveFinal = exports.insertMembroCNP = exports.membroInsert = exports.becomePresidente = exports.addEspecialidade = exports.toggleConselheiro = exports.membroDelete = exports.membroChangeDireccao = exports.changeMembroStatus = exports.membroSearch = exports.membroRegister = void 0;
exports.editArtigo = exports.registerArtigo = exports.deleteCapitulo = exports.searchCapitulos = exports.searchCapituloByNumero = exports.editCapitulo = exports.registerCapitulo = exports.deleteLei = exports.searchLeiByNumero = exports.editLei = exports.registerLei = exports.createMunicipio = exports.createProvincia = exports.createConselho = exports.createPerfil = exports.deleteSchema = exports.saidaCreate = exports.createSituacaoFinanceira = exports.payTaxaByReference = exports.payQuotaByReference = exports.changeImagemNoticia = exports.editNoticia = exports.createNoticia = exports.changeComunicadoStatus = exports.deleteComunicado = exports.editComunicado = exports.createComunicado = exports.getOnePainelEvento = exports.addTemaPainelEvento = exports.createPainelEvento = exports.paramIdPergunta = exports.createPergunta = exports.getInqueritoEvento = exports.paramIdInquerito = exports.createInquerito = exports.createRespostaInquerito = exports.paramIdTema = exports.createTema = exports.paramIdPainel = exports.createPainel = exports.fmesaRedondaRegister = exports.createEvento = exports.docUploadChangeImage = exports.docUploadEdit = exports.docUploadCreate = exports.dadosAcademicoDelete = exports.dadosAcademicoEdit = exports.dadosAcademicoCreate = exports.deleteExperienciaProfissional = exports.editExperienciaProfissional = void 0;
exports.changeReclamacaoStatus = exports.createReclamacao = exports.assembleiaConstitutivaInscricao = exports.createUtilizacaoMedicamento = exports.webAccessRegister = exports.deleteArtigo = exports.searchArtigos = exports.searchArtigoByNumero = void 0;
const express_validator_1 = require("express-validator");
// Membro
exports.membroRegister = (0, express_validator_1.checkSchema)({
    // DadosPessoais
    direccao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo Direcção é obrigatório',
    },
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo genero é obrigatório',
    },
    dataNascimento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo dataNascimento é obrigatório',
    },
    estadoCivil: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo estadoCivil é obrigatório',
    },
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bi é obrigatório',
    },
    nif: {
        trim: true,
    },
    nomePai: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nomePai é obrigatório',
    },
    nomeMae: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nomeMae é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    telefone1: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone1 é obrigatório',
    },
    telefone2: {
        trim: true,
    },
    provincia: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provincia é obrigatório',
    },
    municipio: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipio é obrigatório',
    },
    bairro: {
        trim: true,
    },
    rua: {
        trim: true,
    },
    nacionalidade: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo nacionalidade é obrigatório',
    },
    provinciaNasc: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaNasc é obrigatório',
    },
    municipioNasc: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipioNasc é obrigatório',
    },
    // Dados do Local de trabalho
    instituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo instituicao é obrigatório',
    },
    funcao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo funcao é obrigatório',
    },
    emailInstituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo emailInstituicao é obrigatório',
    },
    tel1Instituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tel1Instituicao é obrigatório',
    },
    tel2Instituicao: {
        trim: true,
    },
    ruaInstituicao: {
        trim: true,
    },
    bairroInstituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bairroInstituicao é obrigatório',
    },
    municipioInstituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipioInstituicao é obrigatório',
    },
    provinciaInstituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaInstituicao é obrigatório',
    },
    direcaoTecnica: {
        trim: true,
    },
    quais: {
        trim: true,
    },
    // Dados Academicos
    cursoLincenciatura: {
        trim: true,
    },
    universidadeLicenciatura: {
        trim: true,
    },
    anoConclusaoLicenciatura: {
        trim: true,
    },
    cidadeLicenciatura: {
        trim: true,
    },
    paisLicenciatura: {
        trim: true,
    },
    cursoPosGraduacao: {
        trim: true,
    },
    universidadePosGraduacao: {
        trim: true,
    },
    anoConclusaoPosGraduacao: {
        trim: true,
    },
    cidadePosGraduacao: {
        trim: true,
    },
    paisPosGraduacao: {
        trim: true,
    },
    cursoMestrado: {
        trim: true,
    },
    universidadeMestrado: {
        trim: true,
    },
    anoConclusaoMestrado: {
        trim: true,
    },
    cidadeMestrado: {
        trim: true,
    },
    paisMestrado: {
        trim: true,
    },
    cursoEspecialidade: {
        trim: true,
    },
    universidadeEspecialidade: {
        trim: true,
    },
    anoConclusaoEspecialidade: {
        trim: true,
    },
    cidadeEspecialidade: {
        trim: true,
    },
    paisEspecialidade: {
        trim: true,
    },
    universidadeDoutoramento: {
        trim: true,
    },
    anoConclusaoDoutoramento: {
        trim: true,
    },
    cidadeDoutoramento: {
        trim: true,
    },
    userId: {
        trim: true,
    },
});
exports.membroSearch = (0, express_validator_1.checkSchema)({
    search: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroSearch é obrigatório',
    },
});
exports.changeMembroStatus = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório!',
    },
    status: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo status é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.membroChangeDireccao = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório!',
    },
    direccao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo direccao é obrigatório!',
    },
    observacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo observacao é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.membroDelete = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório!',
    },
    observacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo observacao é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.toggleConselheiro = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
});
exports.addEspecialidade = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    especialidade: {
        trim: true,
    },
    userId: {
        trim: true,
    },
});
exports.becomePresidente = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
});
exports.membroInsert = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo genero é obrigatório',
    },
    dataNascimento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo dataNascimento é obrigatório',
    },
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bi é obrigatório',
    },
    dataEmissaoBi: {
        trim: true,
    },
    numeroCarteira: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numeroCarteira é obrigatório',
    },
    status: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo status é obrigatório',
    },
    nomePai: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nomePai é obrigatório',
    },
    nomeMae: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nomeMae é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        isEmail: true,
        normalizeEmail: true,
        errorMessage: 'O campo email é obrigatório',
    },
    estadoCivil: {
        trim: true,
    },
    telefone1: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone1 é obrigatório',
    },
    telefone2: {
        trim: true,
    },
    nomeProfissional: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome profissional é obrigatório',
    },
    provinciaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaId é obrigatório',
    },
    municipioId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipioId é obrigatório',
    },
    bairro: {
        trim: true,
    },
    conselhoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo conselhoId é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.insertMembroCNP = (0, express_validator_1.checkSchema)({
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
    adminUserId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo adminUserId é obrigatório',
    },
    numeroCarteira: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numeroCarteira é obrigatório',
    },
});
exports.membroApproveFinal = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    numeroCarteira: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numeroCarteira é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.membroEditDoc = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    nomeDoc: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nomeDoc é obrigatório',
    },
    userId: {
        // notEmpty: true,
        trim: true,
        // errorMessage: 'O campo userId é obrigatório',
    },
});
// solicitacao de  Actualizacao de dados membros
exports.verifyBi = (0, express_validator_1.checkSchema)({
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'Insira o numero do Bilhte de Identidade',
    }
});
exports.membroActualizacaoDados = (0, express_validator_1.checkSchema)({
    membroId: {
        // notEmpty: true,
        trim: true,
        // errorMessage: 'O campo membroId é obrigatório',
    },
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo N de bilhete de identidade é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    tel: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone é obrigatório',
    },
    carteira: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo carteira é obrigatório',
    },
});
// Fim Membro
// Email
exports.emailSend = (0, express_validator_1.checkSchema)({
    from: {
        trim: true,
    },
    to: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo to é obrigatório!',
    },
    subject: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo subject é obrigatório!',
    },
    html: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo html é obrigatório!',
    },
});
exports.emailPosmarkSend = (0, express_validator_1.checkSchema)({
    From: {
        trim: true,
    },
    To: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo To é obrigatório!',
    },
    Subject: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo Subject é obrigatório!',
    },
    HtmlBody: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo HtmlBody é obrigatório!',
    },
    TextBody: {
        trim: true,
    },
    MessageStream: {
        trim: true,
    },
});
// Fim Email
// Solicitacao
exports.solicitacaoRegister = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    tipo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tipo é obrigatório',
    },
    efeito: {
        trim: true,
    },
    emolumentoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo emolumentoId é obrigatório',
    },
});
exports.solicitacaoChangeStatus = (0, express_validator_1.checkSchema)({
    solicitacaoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    status: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo status é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
// Fim Solicitacao
// ---- Agenda
exports.createAgenda = (0, express_validator_1.checkSchema)({
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membro é obrigatório!',
    },
    data: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo data é obrigatório!',
    },
    horaInicio: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo horaInicio é obrigatório!',
    },
    horaTermino: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo horaTermino é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.deleteAgenda = (0, express_validator_1.checkSchema)({
    agendaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo agendaId é obrigatório!',
    },
});
// ---- Fim Agenda
// ---- Agendamento
exports.createAgendamento = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório!',
    },
    tel: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tel é obrigatório!',
    },
    email: {
        normalizeEmail: true,
        trim: true,
        errorMessage: 'Email inválido!',
    },
    assunto: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo assunto é obrigatório!',
    },
    resumo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo resumo é obrigatório!',
    },
    agendaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo agendaId é obrigatório!',
    },
});
// ---- Fim Agendamento
// ---- Emolumento
exports.createEmolumento = (0, express_validator_1.checkSchema)({
    designacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo designacao é obrigatório!',
    },
    valor: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo valor é obrigatório!',
    },
    model: {
        trim: true,
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
// ---- Fim Emolumento
// UserAdmin
exports.createUserAdmin = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo gênero é obrigatório',
    },
    dataNascimento: {
        trim: true,
    },
    bi: {
        trim: true,
    },
    email: {
        notEmpty: true,
        trim: true,
        normalizeEmail: true,
        errorMessage: 'O campo email é obrigatório é obrigatório',
    },
    estadoCivil: {
        trim: true,
    },
    telefone1: {
        trim: true,
    },
    telefone2: {
        trim: true,
    },
    perfil: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo perfil é obrigatório',
    },
    provincia: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo provincia é obrigatório',
    },
    municipio: {
        trim: true,
    },
    bairro: {
        trim: true,
    },
});
exports.makeMembroAdmin = (0, express_validator_1.checkSchema)({
    dadosPessoaisId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo dadosPessoaisId é obrigatório',
    },
    perfil: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo perfil é obrigatório',
    },
    userId: {
        trim: true
    }
});
exports.changeFuncinarioStatus = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório!',
    },
    status: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo status é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
// Fim UserAdmin
// ---- DadosPessoais
exports.dadosPessoaisEdit = (0, express_validator_1.checkSchema)({
    dadosPessoaisId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo dadosPessoaisId é obrigatório',
    },
    nome: {
        trim: true,
    },
    genero: {
        trim: true,
    },
    dataNascimento: {
        trim: true,
    },
    bi: {
        trim: true,
    },
    campanha: {
        trim: true,
    },
    dataEmissaoBi: {
        trim: true,
    },
    nomePai: {
        trim: true,
    },
    nomeMae: {
        trim: true,
    },
    email: {
        trim: true,
    },
    estadoCivil: {
        trim: true,
    },
    provincia: {
        trim: true,
    },
    municipio: {
        trim: true,
    },
    bairro: {
        trim: true,
    },
    rua: {
        trim: true,
    },
    provinciaNasc: {
        trim: true,
    },
    municipioNasc: {
        trim: true,
    },
    nacionalidade: {
        trim: true,
    },
    telefone1: {
        trim: true,
    },
    // userId: {
    //   trim: true,
    //   errorMessage: 'O campo userId é obrigatório'
    // }
});
// ---- Fim DadosPessoais
// Auth
exports.login = (0, express_validator_1.checkSchema)({
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    password: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo senha é obrigatório',
    },
});
exports.loginMembro = (0, express_validator_1.checkSchema)({
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    password: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo senha é obrigatório',
    },
});
exports.isLoggedSchema = (0, express_validator_1.checkSchema)({
    token: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo token é obrigatório!',
    },
});
exports.editPassword = (0, express_validator_1.checkSchema)({
    dadosPessoaisId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo dadosPessoaisId é obrigatório!',
    },
    newPassword: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo newPassword é obrigatório!',
    },
    oldPassword: {
        trim: true,
    },
    userId: {
        trim: true,
    },
    allowedEdit: {
        trim: true,
    },
});
exports.requestVerificationCode = (0, express_validator_1.checkSchema)({
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório!',
    },
});
exports.checkVerificationCode = (0, express_validator_1.checkSchema)({
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório!',
    },
    codigo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo codigo é obrigatório!',
    },
});
exports.loginMembroMobile = (0, express_validator_1.checkSchema)({
    numeroCarteira: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo número de carteira é obrigatório',
    },
    password: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo senha é obrigatório',
    },
});
exports.authRefreshToken = (0, express_validator_1.checkSchema)({
    refreshToken: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo refreshToken é obrigatório',
    }
});
// Fim Auth
// Message / Chat
exports.sendMessageAdminToMembro = (0, express_validator_1.checkSchema)({
    sender: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo sender é obrigatório!',
    },
    content: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo content é obrigatório!',
    },
    receiver: {
        trim: true,
    },
});
exports.sendMessageMembroToAdmin = (0, express_validator_1.checkSchema)({
    sender: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo sender é obrigatório!',
    },
    content: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo content é obrigatório!',
    }
});
exports.messageView = (0, express_validator_1.checkSchema)({
    messageId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo messageId é obrigatório!',
    },
});
// Fim Message / Chat
// Feedback
exports.feedbackSend = (0, express_validator_1.checkSchema)({
    assunto: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo assunto é obrigatório!',
    },
    descricao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo descricao é obrigatório!',
    },
    dadosPessoaisId: {
        trim: true,
    },
});
exports.feedbackDelete = (0, express_validator_1.checkSchema)({
    feedbackId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo feedbackId é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
// Fim Feedback
// Solicitacao
exports.createSolicitacao = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    conselhoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo conselhoId é obrigatório',
    },
    telefone1: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone1 é obrigatório',
    },
    telefone2: {
        trim: true,
    },
    nomePai: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome do pai é obrigatório',
    },
    nomeMae: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome da mãe é obrigatório',
    },
    localNascimento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O local de nascimento é obrigatório',
    },
    dataNascimento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo data de nascimento é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo gênero é obrigatório',
    },
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo número do BI é obrigatório',
    },
    dataEmissaoBI: {
        trim: true,
    },
    email: {
        trim: true,
    },
    membroId: {
        trim: true,
    },
    porMembro: {
        trim: true,
    },
    habilitacoesLiterarias: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo habilitações literárias é obrigatório',
    },
    agregadoFamiliar: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo agregado familiar é obrigatório',
    },
    profissao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo profissão é obrigatório',
    },
    localTrabalho: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo local de trabalho é obrigatório',
    },
    resumo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo resumo do caso é obrigatório',
    },
    provinciaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaId é obrigatório',
    },
    municipioId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipioId é obrigatório',
    },
    bairro: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bairro é obrigatório',
    },
    modoSobrevivencia: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo modo de sobrevivencia é obrigatório',
    },
    outrasReceitas: {
        trim: true,
    },
    userId: {
        trim: true,
    },
});
exports.searchSolicitacaoByNumber = (0, express_validator_1.checkSchema)({
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório',
    },
});
exports.approveSolicitacaoBySecretaria = (0, express_validator_1.checkSchema)({
    solicitacaoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo solicitacaoId é obrigatório',
    },
    tipoCasoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tipoCasoId é obrigatório',
    },
});
exports.approveSolicitacaoByPresidente = (0, express_validator_1.checkSchema)({
    solicitacaoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id da solicitação é obrigatório',
    },
});
// Fim Solicitacao
// Carousel
exports.carouselCreate = (0, express_validator_1.checkSchema)({
    titulo: {
        trim: true,
    },
    descricao: {
        trim: true,
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.carouselEdit = (0, express_validator_1.checkSchema)({
    titulo: {
        trim: true,
    },
    descricao: {
        trim: true,
    },
    status: {
        trim: true,
    },
    carouselId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo carouselId é obrigatório',
    },
    userId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.carouselChangeImage = (0, express_validator_1.checkSchema)({
    carouselId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo carouselId é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
// Fim Carousel
// SiteInfo
exports.siteInfoCreate = (0, express_validator_1.checkSchema)({
    menu: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo menu é obrigatório!',
    },
    opcao: {
        trim: true,
    },
    conteudo: {
        trim: true,
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.siteInfoEdit = (0, express_validator_1.checkSchema)({
    menu: {
        trim: true,
    },
    opcao: {
        trim: true,
    },
    conteudo: {
        trim: true,
    },
    status: {
        trim: true,
    },
    siteInfoId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo siteInfoId é obrigatório',
    },
    userId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.siteInfoChangeImage = (0, express_validator_1.checkSchema)({
    siteInfoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo siteInfoId é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
// Fim SiteInfo
// ExperienciaProfissional
exports.experienciaProfissionalCreate = (0, express_validator_1.checkSchema)({
    instituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo instituicao é obrigatório',
    },
    mesInicio: {
        trim: true,
    },
    anoInicio: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo anoInicio é obrigatório',
    },
    mesTermino: {
        trim: true
    },
    anoTermino: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo anoTermino é obrigatório',
    },
    cargo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo cargo é obrigatório',
    },
    descricao: {
        trim: true
    },
    actual: {
        trim: true,
    },
    tel1: {
        trim: true,
    },
    tel2: {
        trim: true,
    },
    email: {
        trim: true,
    },
    fax: {
        trim: true,
    },
    rua: {
        trim: true,
    },
    bairro: {
        trim: true,
    },
    municipio: {
        trim: true,
    },
    provincia: {
        trim: true,
    },
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo cargo é obrigatório',
    },
});
exports.editExperienciaProfissional = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório',
    },
    instituicao: {
        trim: true,
    },
    mesInicio: {
        trim: true,
    },
    anoInicio: {
        trim: true,
    },
    mesTermino: {
        trim: true
    },
    anoTermino: {
        trim: true
    },
    cargo: {
        trim: true,
    },
    descricao: {
        trim: true
    },
    actual: {
        trim: true,
    },
    tel1: {
        trim: true,
    },
    tel2: {
        trim: true,
    },
    email: {
        trim: true,
    },
    fax: {
        trim: true,
    },
    rua: {
        trim: true,
    },
    bairro: {
        trim: true,
    },
    municipio: {
        trim: true,
    },
    provincia: {
        trim: true,
    },
});
exports.deleteExperienciaProfissional = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório',
    },
});
// Fim ExperienciaProfissional
// FormacaoAcademica
exports.dadosAcademicoCreate = (0, express_validator_1.checkSchema)({
    instituicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo instituicao é obrigatório',
    },
    tipo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tipo é obrigatório',
    },
    curso: {
        trim: true,
    },
    mesInicio: {
        trim: true,
    },
    anoInicio: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo anoInicio é obrigatório',
    },
    mesFim: {
        trim: true,
    },
    anoFim: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo anoTermino é obrigatório',
    },
    nota: {
        trim: true
    },
    descricao: {
        trim: true
    },
    cidade: {
        trim: true
    },
    pais: {
        trim: true
    },
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo cargo é obrigatório',
    },
});
exports.dadosAcademicoEdit = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório',
    },
    tipo: {
        trim: true,
    },
    curso: {
        trim: true,
    },
    instituicao: {
        trim: true,
    },
    mesInicio: {
        trim: true,
    },
    anoInicio: {
        trim: true,
    },
    mesFim: {
        trim: true
    },
    anoFim: {
        trim: true
    },
    cidade: {
        trim: true
    },
    pais: {
        trim: true
    },
    nota: {
        trim: true,
    },
    descricao: {
        trim: true
    }
});
exports.dadosAcademicoDelete = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório',
    },
});
// Fim FormacaoAcademica
// DocsUpload
exports.docUploadCreate = (0, express_validator_1.checkSchema)({
    nomeFile: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome de documento é obrigatório',
    },
    tipoFile: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tipo de documento é obrigatório',
    },
    descricao: {
        trim: true,
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.docUploadEdit = (0, express_validator_1.checkSchema)({
    nomeFile: {
        trim: true,
    },
    tipoFile: {
        trim: true,
    },
    descricao: {
        trim: true,
    },
    status: {
        trim: true,
    },
    docUploadId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo docUploadId é obrigatório',
    },
    userId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.docUploadChangeImage = (0, express_validator_1.checkSchema)({
    docUploadId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo docUploadId é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
// Fim DocsUpload
// Evento
exports.createEvento = (0, express_validator_1.checkSchema)({
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
    edicao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo edição é obrigatório',
    },
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório',
    },
    codEvento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo assunto é obrigatório',
    },
    descricao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo descricao é obrigatório',
    },
});
// Fim Evento
// Mesa Redonda
exports.fmesaRedondaRegister = (0, express_validator_1.checkSchema)({
    encerrado: {
        notEmpty: true,
        trim: true,
        errorMessage: 'As Inscrições jã foram encerradas.!',
    },
    numeroCarteira: {
        trim: true,
    },
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    dataNascimento: {
        // notEmpty: true,
        trim: true,
        // errorMessage: 'O campo Data de nascimento é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo genero é obrigatório',
    },
    profissao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo profissão é obrigatório',
    },
    localTrabalho: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo local de trabalho é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    tel: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone é obrigatório',
    },
});
// Fim Mesa Redonda
// Painel
exports.createPainel = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    }
});
exports.paramIdPainel = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do painel é obrigatório',
    }
});
// Tema
exports.createTema = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório',
    }
});
exports.paramIdTema = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do tema é obrigatório',
    }
});
// Resposta Inquerito
// Inquerito
exports.createRespostaInquerito = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bi é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo genero é obrigatório',
    },
    telefone1: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone1 é obrigatório',
    },
    telefone2: {
        trim: true,
    },
    categoria: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo categoria é obrigatório',
    },
    ordem: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo ordem é obrigatório',
    },
    presenca: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo presenca é obrigatório',
    },
    provincia: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provincia é obrigatório',
    },
    municipio: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipio é obrigatório',
    },
    rua: {
        trim: true,
    },
    inquerito: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo inquerito é obrigatório',
    },
    perguntas: {
        isArray: true, // Verifica se o campo 'perguntas' é um array
        errorMessage: 'O campo perguntas deve ser um array',
    },
    'perguntas.*._id': {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo _id é obrigatório para cada pergunta',
    },
    'perguntas.*.resposta': {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo resposta é obrigatório para cada pergunta',
    },
});
// Inquerito
exports.createInquerito = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    evento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo evento é obrigatório',
    },
});
exports.paramIdInquerito = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do inquérito é obrigatório',
    }
});
exports.getInqueritoEvento = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome do inquérito é obrigatório',
    },
    tituloEvento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo título do evento é obrigatório',
    }
});
// Perguntas
exports.createPergunta = (0, express_validator_1.checkSchema)({
    texto: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo texto é obrigatório',
    },
    inquerito: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo inquerito é obrigatório',
    }
});
exports.paramIdPergunta = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do pergunta é obrigatório',
    }
});
// PainelEvento
exports.createPainelEvento = (0, express_validator_1.checkSchema)({
    evento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do evento é obrigatório',
    },
    painel: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do painel é obrigatório',
    },
});
exports.addTemaPainelEvento = (0, express_validator_1.checkSchema)({
    evento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do evento é obrigatório',
    },
    painel: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do painel é obrigatório',
    },
    id_tema: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do tema é obrigatório',
    },
});
exports.getOnePainelEvento = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O id do painel do evento é obrigatório',
    }
});
// Comunicado
exports.createComunicado = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório',
    },
    conteudo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo conteudo é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.editComunicado = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório',
    },
    conteudo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo conteudo é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
    comunicadoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo comunicadoId é obrigatório',
    },
});
exports.deleteComunicado = (0, express_validator_1.checkSchema)({
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
    comunicadoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo comunicadoId é obrigatório',
    },
});
exports.changeComunicadoStatus = (0, express_validator_1.checkSchema)({
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
    comunicadoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo comunicadoId é obrigatório',
    },
});
// Fim Comunicado
// Noticia
exports.createNoticia = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório',
    },
    fonte: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo fonte é obrigatório',
    },
    conteudo: {
        trim: true,
    },
    destaque: {
        trim: true,
    },
    subTitulo: {
        trim: true,
    },
    status: {
        trim: true,
    },
    categoria: {
        trim: true,
    },
    link: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo fonte é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.editNoticia = (0, express_validator_1.checkSchema)({
    titulo: {
        trim: true,
    },
    fonte: {
        trim: true,
    },
    conteudo: {
        trim: true,
    },
    regiao: {
        trim: true,
    },
    destaque: {
        trim: true,
    },
    subTitulo: {
        trim: true,
    },
    link: {
        trim: true,
    },
    status: {
        trim: true,
    },
    noticiaId: {
        trim: true,
        errorMessage: 'O campo noticiaId é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
exports.changeImagemNoticia = (0, express_validator_1.checkSchema)({
    noticiaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo noticiaId é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
});
// Fim Noticia
// Pagamento
exports.payQuotaByReference = (0, express_validator_1.checkSchema)({
    montante: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo montante é obrigatório',
    },
    emolumentoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo emolumentoId é obrigatório',
    },
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    mes: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo mes é obrigatório',
    },
    ano: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo ano é obrigatório',
    },
});
exports.payTaxaByReference = (0, express_validator_1.checkSchema)({
    emolumentoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo emolumentoId é obrigatório',
    },
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo membroId é obrigatório',
    },
    userId: {
        trim: true,
    },
});
// Fim Pagamento
// SituacaoFinanceira
exports.createSituacaoFinanceira = (0, express_validator_1.checkSchema)({
    ano: {
        notEmpty: true,
        trim: true,
        errorMessage: "O campo ano é obrigatório"
    },
    mesInicial: {
        notEmpty: true,
        trim: true,
        errorMessage: "O campo mesInicial é obrigatório"
    },
    mesFinal: {
        trim: true,
    },
    membroId: {
        notEmpty: true,
        trim: true,
        errorMessage: "O campo membroId é obrigatório"
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: "O campo userId é obrigatório"
    },
});
// Fim SituacaoFinanceira
// Saida
exports.saidaCreate = (0, express_validator_1.checkSchema)({
    valor: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo valor é obrigatório!',
    },
    descricao: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo descricao é obrigatório!',
    },
    funcionario: {
        trim: true,
    },
    tipo: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo tipo é obrigatório!',
    },
    userId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
// Fim Saida
// Geral 
exports.deleteSchema = (0, express_validator_1.checkSchema)({
    id: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo id é obrigatório!',
    },
    userId: {
        trim: true,
        notEmpty: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
// Fim Geral
// Perfil
exports.createPerfil = (0, express_validator_1.checkSchema)({
    designacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo designação é obrigatório',
    },
});
// Fim Perfil
// Conselho
exports.createConselho = (0, express_validator_1.checkSchema)({
    designacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo designação é obrigatório',
    },
    telefone: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    sigla: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo sigla é obrigatório',
    },
    provinciaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaId é obrigatório',
    },
    municipioId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipioId é obrigatório',
    },
    bairro: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bairro é obrigatório',
    },
});
// Fim Conselho
// Provincia
exports.createProvincia = (0, express_validator_1.checkSchema)({
    designacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo designação é obrigatório',
    },
});
// Fim Provincia
// Municipio
exports.createMunicipio = (0, express_validator_1.checkSchema)({
    designacao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo designação é obrigatório!',
    },
    provinciaId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaId é obrigatório!',
    },
});
// Fim Municipio
// Lei
exports.registerLei = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório!',
    },
});
exports.editLei = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
    leiId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo leiId é obrigatório!',
    },
});
exports.searchLeiByNumero = (0, express_validator_1.checkSchema)({
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório!',
    },
});
exports.deleteLei = (0, express_validator_1.checkSchema)({
    leiId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo leiId é obrigatório!',
    },
});
// Fim Lei
// Capitulo
exports.registerCapitulo = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.editCapitulo = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
    capituloId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo capituloId é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.searchCapituloByNumero = (0, express_validator_1.checkSchema)({
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório!',
    },
});
exports.searchCapitulos = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
});
exports.deleteCapitulo = (0, express_validator_1.checkSchema)({
    capituloId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo capituloId é obrigatório!',
    },
});
// Fim Capitulo
// Capitulo
exports.registerArtigo = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório!',
    },
    alineas: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo alineas é obrigatório!',
    },
    capituloId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo capituloId é obrigatório!',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório!',
    },
});
exports.editArtigo = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
    capituloId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo capituloId é obrigatório!',
    },
    artigoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo artigoId é obrigatório!',
    },
});
exports.searchArtigoByNumero = (0, express_validator_1.checkSchema)({
    numero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo numero é obrigatório!',
    },
});
exports.searchArtigos = (0, express_validator_1.checkSchema)({
    titulo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo titulo é obrigatório!',
    },
});
exports.deleteArtigo = (0, express_validator_1.checkSchema)({
    artigoId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo artigoId é obrigatório!',
    },
});
// Fim Artigo
// WebAccess
exports.webAccessRegister = (0, express_validator_1.checkSchema)({
    dadosPessoaisId: {
        trim: true,
    },
    country: {
        trim: true,
    },
    lat: {
        trim: true,
    },
    lon: {
        trim: true,
    },
    isp: {
        trim: true,
    },
    timezone: {
        trim: true,
    },
    ip: {
        trim: true,
    },
    device: {
        trim: true,
    },
    state: {
        trim: true,
    },
    road: {
        trim: true,
    },
    formatted: {
        trim: true,
    },
    page: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo page é obrigatório!',
    },
});
// Fim WebAccess
// Início UtilizacaoMedicamento
exports.createUtilizacaoMedicamento = (0, express_validator_1.checkSchema)({
    tipo: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo tipo é obrigatório!',
    },
    descricao: {
        trim: true,
    }
});
// Fim UtilizacaoMedicamento
exports.assembleiaConstitutivaInscricao = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    genero: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo genero é obrigatório',
    },
    dataNascimento: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo dataNascimento é obrigatório',
    },
    // estadoCivil: {
    //   trim: true,
    //   notEmpty: true,
    //   errorMessage: 'O campo estadoCivil é obrigatório',
    // },
    bi: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo bi é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    telefone1: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo telefone1 é obrigatório',
    },
    telefone2: {
        trim: true,
    },
    provincia: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provincia é obrigatório',
    },
    municipio: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo municipio é obrigatório',
    },
    bairro: {
        trim: true,
    },
    rua: {
        trim: true,
    },
    provinciaNasc: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo provinciaNasc é obrigatório',
    },
    // municipioNasc: {
    //   notEmpty: true,
    //   trim: true,
    //   errorMessage: 'O campo municipioNasc é obrigatório',
    // },
});
// Reclamacao
exports.createReclamacao = (0, express_validator_1.checkSchema)({
    nome: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo nome é obrigatório',
    },
    email: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo email é obrigatório',
    },
    tel: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo contacto é obrigatório',
    },
    assunto: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo assunto é obrigatório',
    },
    descricao: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo descricao é obrigatório',
    },
});
exports.changeReclamacaoStatus = (0, express_validator_1.checkSchema)({
    id: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo id é obrigatório',
    },
    userId: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo userId é obrigatório',
    },
    status: {
        notEmpty: true,
        trim: true,
        errorMessage: 'O campo status é obrigatório',
    },
});
// Fim reclamacao
