"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getObjet = exports.deleteFile = exports.getURL = exports.uploadFile = void 0;
const client_s3_1 = require("@aws-sdk/client-s3");
const s3_request_presigner_1 = require("@aws-sdk/s3-request-presigner");
const validate_url_1 = __importDefault(require("./validate-url"));
const bucket = process.env.AWS_BUCKET_NAME;
const region = process.env.AWS_BUCKET_REGION;
const accessKeyId = process.env.AWS_ACCESS_KEY;
const secretAccessKey = process.env.AWS_SECRET_KEY;
// Cria o objecto s3Client
const s3Client = new client_s3_1.S3Client({
    region,
    credentials: {
        accessKeyId,
        secretAccessKey
    }
});
// Funcao que faz o upload de arquivo
function uploadFile(file) {
    const uploadParams = {
        Bucket: bucket,
        Body: file.buffer,
        Key: file.filename,
        ContentType: file.mimetype
    };
    return s3Client.send(new client_s3_1.PutObjectCommand(uploadParams));
}
exports.uploadFile = uploadFile;
// Funcao que faz o download do arquivo
function getURL(key, duraction) {
    const command = new client_s3_1.GetObjectCommand({
        Bucket: bucket,
        Key: key
    });
    if ((0, validate_url_1.default)(key)) {
        return key;
    }
    return (0, s3_request_presigner_1.getSignedUrl)(s3Client, command, { expiresIn: duraction ? duraction : 3600 });
}
exports.getURL = getURL;
// Funcao para deletar o arquivo
function deleteFile(key) {
    const command = new client_s3_1.DeleteObjectCommand({
        Bucket: bucket,
        Key: key
    });
    return s3Client.send(command);
}
exports.deleteFile = deleteFile;
function getObjet(key) {
    const command = new client_s3_1.GetObjectCommand({
        Bucket: bucket,
        Key: key
    });
    return s3Client.send(command);
}
exports.getObjet = getObjet;
