"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateRefreshToken = exports.validateSignature = exports.deleteDocs = exports.getDocsURL = exports.createHistoricoActividade = exports.capitalizeFirstCharacter = exports.validarExpiracao24h = exports.getActividadeAction = exports.sendCreds = exports.sortBy = exports.generatePassword = exports.formatDate = exports.getAngolaTime = exports.filterByWeek = exports.filterByMonth = exports.filterByYear = exports.getDiaDaSemana = exports.getMes = void 0;
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const historico_actividade_1 = __importDefault(require("../models/historico-actividade"));
const membro_1 = __importDefault(require("../models/membro"));
const user_1 = __importDefault(require("../models/user"));
const aws_1 = require("./aws");
const validate_url_1 = __importDefault(require("./validate-url"));
const verification_code_1 = __importDefault(require("./verification-code"));
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const crypto_1 = __importDefault(require("crypto"));
const refresh_token_1 = __importDefault(require("../models/refresh-token"));
const date_fns_1 = require("date-fns");
const postmark_1 = __importDefault(require("../services/postmark"));
const getMes = (mes) => {
    const meses = [
        'Janeiro',
        'Fevereiro',
        'Março',
        'Abril',
        'Maio',
        'Junho',
        'Julho',
        'Agosto',
        'Setembro',
        'Outubro',
        'Novembro',
        'Dezembro',
    ];
    return meses[mes - 1];
};
exports.getMes = getMes;
const getDiaDaSemana = (dia) => {
    const diasDaSemana = [
        'Domingo',
        'Segunda feira',
        'Terça feira',
        'Quarta feira',
        'Quinta feira',
        'Sexta feira',
        'Sábado',
    ];
    return diasDaSemana[dia];
};
exports.getDiaDaSemana = getDiaDaSemana;
const filterByYear = (year) => {
    const startDate = new Date(year, 0, 1);
    const endDate = new Date(year, 11, 31);
    return {
        $gte: startDate,
        $lte: endDate,
    };
};
exports.filterByYear = filterByYear;
const filterByMonth = (year, month) => {
    const startDate = new Date(year, month, 1);
    const endDate = new Date(year, month + 1, 0);
    return {
        $gte: startDate,
        $lte: endDate,
    };
};
exports.filterByMonth = filterByMonth;
const filterByWeek = (year, week) => {
    const startDate = new Date(year, 0, 1); // 1st day of the year
    startDate.setDate(startDate.getDate() + (week - 1) * 7); // Move to the first day of the target week
    const endDate = new Date(startDate);
    endDate.setDate(endDate.getDate() + 6); // Move to the last day of the week
    return {
        $gte: startDate,
        $lte: endDate,
    };
};
exports.filterByWeek = filterByWeek;
const getAngolaTime = () => {
    return new Date().toLocaleString('en-Us', { timeZone: 'Africa/Luanda' });
};
exports.getAngolaTime = getAngolaTime;
const formatDate = (date) => {
    return new Date(date.getFullYear(), date.getMonth(), date.getDate());
};
exports.formatDate = formatDate;
const generatePassword = async () => {
    const password = 'CNPUSER' + (0, verification_code_1.default)(6) + 'CPL';
    const hashPassword = bcryptjs_1.default.hash(password, 12);
    return hashPassword;
};
exports.generatePassword = generatePassword;
const sortBy = (sort) => {
    const [field, sortOrder] = sort.split(':');
    const sortObject = {
        [field]: sortOrder.toUpperCase() === 'DESC' ? -1 : 1,
    };
    return sortObject;
};
exports.sortBy = sortBy;
// Método para alterar e enviar credenciais dos membros
const sendCreds = async () => {
    try {
        let dataActual = new Date((0, exports.getAngolaTime)());
        let anoActual = dataActual.getFullYear();
        let mesActual = dataActual.getMonth() + 1;
        let diaActual = dataActual.getDate();
        let hora = dataActual.getHours();
        let minutos = dataActual.getMinutes();
        let segundos = dataActual.getSeconds();
        if (diaActual === 24 && hora === 11 && minutos === 46 && segundos === 0) {
            const dadosPessoais = await dados_pessoais_1.default.find({
                perfil: { $ne: 'Presidente' },
            });
            let index = 0;
            for (let dados of dadosPessoais) {
                console.log('Index: ', index);
                const membro = await membro_1.default.findOne({ dadosPessoais: dados.id });
                console.log('membro', membro);
                if (membro) {
                    const user = await user_1.default.findOne({ membro: membro.id });
                    console.log('user', user);
                    if (user &&
                        user.email !== 'mourajc@hotmail.com' &&
                        user.email !== '') {
                        const password = 'CNPUSER' + (0, verification_code_1.default)(6) + 'CPL';
                        const hashPassword = await bcryptjs_1.default.hash(password, 12);
                        user.password = hashPassword;
                        await user.save();
                        await postmark_1.default.sendEmail({
                            To: user.email,
                            From: process.env.SENDER_EMAIL,
                            Subject: `Conta CNP - Conselho Provincial de Luanda (CPL)`,
                            HtmlBody: `<h1>Bem Vindo ao CPL Digital - CNP</h1>
                <p>Parabéns ${dados.genero === 'M' ? 'Dr.' : 'Dra.'}  ${dados.nome} foi ${dados.genero === 'M' ? 'inserido' : 'inserida'} com sucesso na plataforma CNP 🎉. </p>

                <p>Seja bem vinda, segue a baixo as credendencias para acender o CPL Digital na plataforma CNP:</p>

                <h3>Credenciais</h3>

                <p>email: ${user.email} | Carteira: ${membro.numeroCarteira} </p>

                <p>Senha: ${password}</p>

                <p><b>Link do Site:</b> <a href="https://cpl.cnp.ao" target="_blank">cpl.cnp.ao</a></p>
                
                <p><b>Baixe o aplicativo:</b> <a href="https://play.google.com/store/apps/details?id=com.cnpdigital.cnpao&pli=1" target="_blank">CNP Carteira Digital</a></p>

                <p><b>NOTA:</b>Senha gerada automaticamente poderá alterar na plataforma</p>
                <p><i>Este e-mail foi gerado automaticamente pela plataforma CNP</i></p>
              `,
                            MessageStream: 'outbound'
                        });
                    }
                }
                index++;
            }
        }
    }
    catch (err) { }
};
exports.sendCreds = sendCreds;
const getActividadeAction = (status) => {
    switch (status) {
        case 'Activo':
            return 'Activação';
        case 'Inactivo':
            return 'Inactivação';
        case 'Suspenso':
            return 'Suspensão';
        case 'Análise-Secretaria':
            return 'Análise';
        case 'Análise-AT':
            return 'Análise';
        case 'Análise-AT':
            return 'Análise';
        case 'Análise':
            return 'Análise';
        case 'Aprovado':
            return 'Aprovação';
        default:
            return status;
    }
};
exports.getActividadeAction = getActividadeAction;
// Funcao para calcular a expiracao em milisegundo
const validarExpiracao24h = (dataEntrada, dataAtual) => {
    const diffEmMilissegundos = new Date(dataAtual).getTime() - new Date(dataEntrada).getTime();
    const umDiaEmMilissegundos = 24 * 60 * 60 * 1000; // 24 horas em milissegundos
    return diffEmMilissegundos < umDiaEmMilissegundos;
};
exports.validarExpiracao24h = validarExpiracao24h;
const capitalizeFirstCharacter = (str) => {
    if (str.length === 0) {
        return str; // Return an empty string if input is empty
    }
    const firstChar = str.charAt(0).toUpperCase();
    const restOfString = str.slice(1).toLowerCase(); // Get the rest of the string (excluding the first character)
    return firstChar + restOfString;
};
exports.capitalizeFirstCharacter = capitalizeFirstCharacter;
const createHistoricoActividade = async (action, modelName, modelId, user, description) => {
    if (user)
        if (user.funcao === 'CNP') {
            historico_actividade_1.default.create({
                action,
                modelName: modelName,
                modelId: modelId,
                user: user.id,
                cnp: true,
                description
            });
        }
        else {
            historico_actividade_1.default.create({
                action,
                modelName: modelName,
                modelId: modelId,
                user: user.id,
                cnp: false,
                description
            });
        }
};
exports.createHistoricoActividade = createHistoricoActividade;
const getDocsURL = async (membro) => {
    if (membro.docs) {
        const docs = membro.docs;
        if (docs) {
            const keys = Object.keys(docs);
            for (const key of keys) {
                let value = docs[key];
                if (value && !(0, validate_url_1.default)(value)) {
                    docs[key] = await (0, aws_1.getURL)(value);
                }
            }
        }
    }
};
exports.getDocsURL = getDocsURL;
const deleteDocs = async (membro) => {
    if (membro.docs) {
        const docs = membro.docs;
        if (docs) {
            const keys = Object.keys(docs);
            for (const key of keys) {
                let value = docs[key];
                if (value) {
                    await (0, aws_1.deleteFile)(value);
                }
            }
        }
    }
};
exports.deleteDocs = deleteDocs;
const validateSignature = (token, rowBody, signature) => {
    let isEqual = true;
    // Create a HMAC-SHA-256 hash
    const hmac = crypto_1.default.createHmac('sha256', token);
    hmac.update(JSON.stringify(rowBody));
    // Get the Hex encoded hash
    const hexEncodedHash = hmac.digest('hex');
    // console.log('hexEncod', hexEncodedHash);
    if (signature !== hexEncodedHash) {
        return (isEqual = false);
    }
    return isEqual;
};
exports.validateSignature = validateSignature;
const generateRefreshToken = async (userId) => {
    const refreshTokens = await refresh_token_1.default.find({ user: userId });
    for (let refresh of refreshTokens) {
        await refresh.delete();
    }
    let expiresIn = (0, date_fns_1.addSeconds)(new Date(), 15);
    return await refresh_token_1.default.create({ user: userId, expiresIn });
};
exports.generateRefreshToken = generateRefreshToken;
