"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPage = exports.skip = exports.paginationResult = void 0;
const paginationResult = (total, page, perPage) => {
    return {
        totalItems: total,
        perPage: perPage,
        hasNextPage: perPage * page < total,
        hasPreviousPage: page > 1,
        nextPage: page + 1,
        previousPage: page - 1,
        lastPage: Math.ceil(total / perPage),
    };
};
exports.paginationResult = paginationResult;
// Método que retorna quantas páginas vai pular
const skip = (page, perPage) => (page - 1) * perPage;
exports.skip = skip;
const getPage = (page) => +page || 1;
exports.getPage = getPage;
