"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteAgenda = exports.getAgenda = exports.getAgendasByMembro = exports.getAgendas = exports.createAgenda = void 0;
const express_validator_1 = require("express-validator");
const agenda_1 = __importDefault(require("../models/agenda"));
const aws_1 = require("../util/aws");
const membro_1 = __importDefault(require("../models/membro"));
const main_1 = require("../util/main");
const validate_url_1 = __importDefault(require("../util/validate-url"));
const pagination_1 = require("../util/pagination");
// Metodo Para criar agenda
const createAgenda = async (req, res, next) => {
    try {
        let { membroId, horaInicio, horaTermino, data, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const date = new Date(data);
        const diaDaSemana = (0, main_1.getDiaDaSemana)(date.getDay());
        const dia = date.getDate();
        const mes = date.getMonth() + 1;
        const ano = date.getFullYear();
        const minutoInicio = +horaInicio.split(':')[1];
        horaInicio = +horaInicio.split(':')[0];
        const minutoTermino = +horaTermino.split(':')[1];
        horaTermino = +horaTermino.split(':')[0];
        if (horaInicio > horaTermino) {
            const error = new Error('Hora de ínicio maior que hora de término!');
            error.statusCode = 422;
            throw error;
        }
        const foundAgenda = await agenda_1.default.findOne({
            dia: dia,
            mes: mes,
            ano: ano,
            horaInicio: horaInicio,
            minutoInicio: minutoInicio,
            horaTermino: horaTermino,
            minutoTermino: minutoTermino,
            membro: membroId,
        });
        if (foundAgenda) {
            const error = new Error(`Conselheiro já agendado para ${foundAgenda.dia} ${(0, main_1.getMes)(foundAgenda.mes)} ${foundAgenda.ano} das ${foundAgenda.horaInicio}:${foundAgenda.minutoInicio}-${foundAgenda.horaTermino}:${foundAgenda.minutoTermino}`);
            error.statusCode = 422;
            throw error;
        }
        const foundAgenda1 = await agenda_1.default.findOne({
            dia: dia,
            mes: mes,
            ano: ano,
            horaInicio: { $gte: horaInicio, $lte: horaTermino },
            horaTermino: { $gt: horaInicio, $gte: horaTermino },
            membro: membroId,
        });
        if (foundAgenda1) {
            const error = new Error(`Conselheiro já agendado das ${foundAgenda1.horaInicio}:${foundAgenda1.minutoInicio}-${foundAgenda1.horaTermino}:${foundAgenda1.minutoTermino} para ${foundAgenda1.dia} de ${(0, main_1.getMes)(foundAgenda1.mes)} de ${foundAgenda1.ano}`);
            error.statusCode = 422;
            throw error;
        }
        const foundAgenda2 = await agenda_1.default.findOne({
            dia: dia,
            mes: mes,
            ano: ano,
            horaInicio: { $lte: horaInicio, $lt: horaTermino },
            horaTermino: { $gt: horaInicio, $lte: horaTermino },
            membro: membroId,
        });
        if (foundAgenda2) {
            const error = new Error(`Conselheiro já agendado das ${foundAgenda2.horaInicio}:${foundAgenda2.minutoInicio}-${foundAgenda2.horaTermino}:${foundAgenda2.minutoTermino} para ${foundAgenda2.dia} de ${(0, main_1.getMes)(foundAgenda2.mes)} de ${foundAgenda2.ano}`);
            error.statusCode = 422;
            throw error;
        }
        const foundAgenda3 = await agenda_1.default.findOne({
            $and: [
                { dia: dia },
                { mes: mes },
                { ano: ano },
                { horaInicio: { $lt: horaInicio } },
                { horaInicio: { $lt: horaTermino } },
                { horaTermino: { $gt: horaInicio } },
                { horaTermino: { $gt: horaTermino } },
                { membro: membroId },
            ],
        });
        if (foundAgenda3) {
            const error = new Error(`Conselheiro já agendado das ${foundAgenda3.horaInicio}:${foundAgenda3.minutoInicio}-${foundAgenda3.horaTermino}:${foundAgenda3.minutoTermino} para ${foundAgenda3.dia} de ${(0, main_1.getMes)(foundAgenda3.mes)} de ${foundAgenda3.ano}`);
            error.statusCode = 422;
            throw error;
        }
        const foundAgenda4 = await agenda_1.default.findOne({
            $and: [
                { dia: dia },
                { mes: mes },
                { ano: ano },
                { horaInicio: { $gt: horaInicio } },
                { horaInicio: { $lt: horaTermino } },
                { horaTermino: { $gt: horaInicio } },
                { horaTermino: { $lt: horaTermino } },
                { membro: membroId },
            ],
        });
        if (foundAgenda4) {
            const error = new Error(`Conselheiro já agendado das ${foundAgenda4.horaInicio}:${foundAgenda4.minutoInicio}-${foundAgenda4.horaTermino}:${foundAgenda4.minutoTermino} para ${foundAgenda4.dia} de ${(0, main_1.getMes)(foundAgenda4.mes)} de ${foundAgenda4.ano}`);
            error.statusCode = 422;
            throw error;
        }
        if (horaInicio === horaTermino) {
            if (minutoInicio > minutoTermino) {
                const error = new Error('Hora de ínicio maior que hora de término!');
                error.statusCode = 422;
                throw error;
            }
            const foundAgenda5 = await agenda_1.default.findOne({
                dia: dia,
                mes: mes,
                ano: ano,
                horaInicio: horaInicio,
                horaTermino: horaTermino,
                minutoInicio: { $gte: minutoInicio, $lte: minutoTermino },
                minutoTermino: { $gt: minutoInicio, $gte: minutoTermino },
                membro: membroId,
            });
            if (foundAgenda5) {
                const error = new Error(`Conselheiro já agendado das ${foundAgenda5.horaInicio}:${foundAgenda5.minutoInicio}-${foundAgenda5.horaTermino}:${foundAgenda5.minutoTermino} para ${foundAgenda5.dia} de ${(0, main_1.getMes)(foundAgenda5.mes)} de ${foundAgenda5.ano}`);
                error.statusCode = 422;
                throw error;
            }
            const foundAgenda6 = await agenda_1.default.findOne({
                dia: dia,
                mes: mes,
                ano: ano,
                horaInicio: horaInicio,
                horaTermino: horaTermino,
                minutoInicio: { $lte: minutoInicio, $lt: minutoTermino },
                minutoTermino: { $gt: minutoInicio, $lte: minutoTermino },
                membro: membroId,
            });
            if (foundAgenda6) {
                const error = new Error(`Conselheiro já agendado das ${foundAgenda6.horaInicio}:${foundAgenda6.minutoInicio}-${foundAgenda6.horaTermino}:${foundAgenda6.minutoTermino} para ${foundAgenda6.dia} de ${(0, main_1.getMes)(foundAgenda6.mes)} de ${foundAgenda6.ano}`);
                error.statusCode = 422;
                throw error;
            }
            const foundAgenda7 = await agenda_1.default.findOne({
                $and: [
                    { dia: dia },
                    { mes: mes },
                    { ano: ano },
                    { horaInicio: horaInicio },
                    { horaTermino: horaTermino },
                    { minutoInicio: { $lt: minutoInicio } },
                    { minutoInicio: { $lt: minutoTermino } },
                    { minutoTermino: { $gt: minutoInicio } },
                    { minutoTermino: { $gt: minutoTermino } },
                    { membro: membroId },
                ],
            });
            if (foundAgenda7) {
                const error = new Error(`Conselheiro já agendado das ${foundAgenda7.horaInicio}:${foundAgenda7.minutoInicio}-${foundAgenda7.horaTermino}:${foundAgenda7.minutoTermino} para ${foundAgenda7.dia} de ${(0, main_1.getMes)(foundAgenda7.mes)} de ${foundAgenda7.ano}`);
                error.statusCode = 422;
                throw error;
            }
            const foundAgenda8 = await agenda_1.default.findOne({
                $and: [
                    { dia: dia },
                    { mes: mes },
                    { ano: ano },
                    { horaInicio: horaInicio },
                    { horaTermino: horaTermino },
                    { minutoInicio: { $lt: minutoInicio } },
                    { minutoInicio: { $lt: minutoTermino } },
                    { minutoTermino: { $gt: minutoInicio } },
                    { minutoTermino: { $lt: minutoTermino } },
                    { membro: membroId },
                ],
            });
            if (foundAgenda8) {
                const error = new Error(`Conselheiro já agendado das ${foundAgenda8.horaInicio}:${foundAgenda8.minutoInicio}-${foundAgenda8.horaTermino}:${foundAgenda8.minutoTermino} para ${foundAgenda8.dia} de ${(0, main_1.getMes)(foundAgenda8.mes)} de ${foundAgenda8.ano}`);
                error.statusCode = 422;
                throw error;
            }
        }
        const agenda = new agenda_1.default({
            dia,
            mes,
            ano,
            diaDaSemana,
            horaInicio,
            minutoInicio,
            horaTermino,
            minutoTermino,
            membro: membroId,
            admin: userId,
        });
        await agenda.save();
        // if (Boolean(email)) {
        //   const msg = {
        //     to: email,
        //     from: process.env.SENDER_EMAIL!,
        //     subject: `Pedido de Assistência`,
        //     html: `<h1>Pedido de Assistência no ${conselho.designacao} (${conselho.sigla})</h1>
        //     <p>
        //       Parabéns o seu Pedido de Assistencia foi feito com sucesso no ${conselho.sigla}.
        //       O seu processo está em análise, cumprindo tudos os requisitos, em altura oportuna enviaremos
        //       um email a confirmar a aprovação.
        //     </p>
        //   `,
        //   };
        //   await mailer.send(msg);
        // }
        res.status(201).json({
            msg: 'Agenda criada com sucesso',
            agenda,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createAgenda = createAgenda;
/*
  Metodo que busca todas as agendas disponiveis
  permite a passagem do estatus como parametro
*/
const getAgendas = async (req, res, next) => {
    try {
        const status = req.query.status;
        const date = new Date((0, main_1.getAngolaTime)());
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObj = {
            status: 'Disponivel',
            ano: { $gte: date.getFullYear() },
            mes: { $gte: date.getMonth() + 1 },
        };
        if (Boolean(status)) {
            filterObj.status = status;
        }
        const total = await agenda_1.default.find(filterObj).count();
        const agendas = await agenda_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('agendamento')
            .populate({
            path: 'membro',
            populate: [{ path: 'dadosPessoais' }],
        });
        const filteredAgendas = agendas.filter((a) => {
            let naoPassou = true;
            if (a.dia < date.getDate()) {
                naoPassou = false;
            }
            if (a.dia === date.getDate() && a.horaTermino < date.getHours()) {
                naoPassou = false;
            }
            if (a.dia === date.getDate() &&
                a.horaTermino === date.getHours() &&
                a.minutoTermino < date.getMinutes()) {
                naoPassou = false;
            }
            return naoPassou;
        });
        for (const agenda of filteredAgendas) {
            const membro = agenda === null || agenda === void 0 ? void 0 : agenda.membro;
            const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
            if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais.fotoURL)) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            agendas: filteredAgendas,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAgendas = getAgendas;
/*
  Metodo que busca todas as agendas disponiveis
  permite a passagem do estatus como parametro
*/
const getAgendasByMembro = async (req, res, next) => {
    try {
        const { membroId } = req.params;
        const status = req.query.status;
        const date = new Date((0, main_1.getAngolaTime)());
        const page = (0, pagination_1.getPage)(req.body.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObj = {
            status: 'Disponivel',
            ano: { $gte: date.getFullYear() },
            mes: { $gte: date.getMonth() + 1 },
            membro: membroId,
        };
        if (Boolean(status)) {
            filterObj.status = status;
        }
        const membro = await membro_1.default.findById(membroId).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const total = await agenda_1.default.find(filterObj).count();
        const agendas = await agenda_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate('agendamento');
        const filteredAgendas = agendas.filter((a) => {
            let naoPassou = true;
            if (a.dia < date.getDate()) {
                naoPassou = false;
            }
            if (a.dia === date.getDate() && a.horaTermino < date.getHours()) {
                naoPassou = false;
            }
            if (a.dia === date.getDate() &&
                a.horaTermino === date.getHours() &&
                a.minutoTermino < date.getMinutes()) {
                naoPassou = false;
            }
            return naoPassou;
        });
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
        }
        res.status(200).json({
            msg: 'Sucesso',
            agendas: filteredAgendas,
            membro,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAgendasByMembro = getAgendasByMembro;
// Metodo que busca agenda pelo Id
const getAgenda = async (req, res, next) => {
    try {
        const { id } = req.params;
        const agenda = await agenda_1.default.findById(id)
            .populate('agendamento')
            .populate({
            path: 'membro',
            populate: [{ path: 'dadosPessoais' }],
        });
        if (!agenda) {
            const error = new Error('Agenda não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        const membro = agenda === null || agenda === void 0 ? void 0 : agenda.membro;
        const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', agenda: agenda });
    }
    catch (err) {
        next(err);
    }
};
exports.getAgenda = getAgenda;
const deleteAgenda = async (req, res, next) => {
    try {
        const { agendaId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const agenda = await agenda_1.default.findById(agendaId);
        if (!agenda) {
            const error = new Error(`Agenda não encontrada!`);
            error.statusCode = 422;
            throw error;
        }
        await agenda_1.default.deleteOne({ _id: agendaId });
        res.status(204).json({
            msg: 'Deletado com sucesso',
        });
    }
    catch (error) {
        next(error);
    }
};
exports.deleteAgenda = deleteAgenda;
