"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deletePermante = exports.editExperienciaProfissional = exports.getExperienciaProfissional = exports.getExperienciasProfissionaisByMembro = exports.createExperienciaProfissional = void 0;
const file_1 = require("../util/file");
const express_validator_1 = require("express-validator");
const experiencia_profissional_1 = __importDefault(require("../models/experiencia-profissional"));
const aws_1 = require("../util/aws");
const pagination_1 = require("../util/pagination");
const membro_1 = __importDefault(require("../models/membro"));
// Metodo Para criar experienciaProfissional
const createExperienciaProfissional = async (req, res, next) => {
    try {
        const { instituicao, mesInicio, anoInicio, mesTermino, anoTermino, cargo, descricao, actual, tel1, tel2, email, fax, rua, bairro, municipio, provincia, membroId, } = req.body;
        const anexo = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        // if (!JSON.parse(actual) && !Boolean(mesTermino)) {
        //   const error: IError = new Error('O campo mesTermino é obrigatório');
        //   error.statusCode = 422;
        //   throw error;
        // }
        // if (!JSON.parse(actual) && !Boolean(anoTermino)) {
        //   const error: IError = new Error('O campo anoTermino é obrigatório');
        //   error.statusCode = 422;
        //   throw error;
        // }
        const experienciaProfissional = new experiencia_profissional_1.default({
            instituicao,
            anoInicio,
            anoTermino,
            cargo,
            actual,
            membro: membroId,
        });
        if (Boolean(mesInicio)) {
            experienciaProfissional.mesInicio = mesInicio;
        }
        if (Boolean(mesTermino)) {
            experienciaProfissional.mesTermino = mesTermino;
        }
        if (Boolean(descricao)) {
            experienciaProfissional.descricao = descricao;
        }
        if (Boolean(tel1)) {
            experienciaProfissional.tel1 = tel1;
        }
        if (Boolean(tel2)) {
            experienciaProfissional.tel2 = tel2;
        }
        if (Boolean(fax)) {
            experienciaProfissional.fax = fax;
        }
        // if (Boolean(rua)) {
        //   experienciaProfissional.rua = rua;
        // }
        if (Boolean(bairro)) {
            experienciaProfissional.bairro = bairro;
        }
        if (Boolean(municipio)) {
            experienciaProfissional.municipio = municipio;
        }
        if (Boolean(provincia)) {
            experienciaProfissional.provincia = provincia;
        }
        if (Boolean(email)) {
            experienciaProfissional.email = email;
        }
        if (JSON.parse(actual)) {
            await experiencia_profissional_1.default.findOneAndUpdate({ actual: true }, // Query
            { actual: false }, // Update
            { new: true, useFindAndModify: false });
        }
        if (anexo) {
            anexo.filename = (0, file_1.generateFileName)(anexo);
            experienciaProfissional.anexo = anexo.filename;
        }
        await experienciaProfissional.save();
        if (anexo) {
            await (0, aws_1.uploadFile)(anexo);
        }
        res.status(201).json({
            msg: 'Sucesso',
            experienciaProfissional,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createExperienciaProfissional = createExperienciaProfissional;
// Metodo que busca todas experienciasProfissionais de um Membro
const getExperienciasProfissionaisByMembro = async (req, res, next) => {
    try {
        const { membroId } = req.params;
        const filterObj = { membro: membroId };
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const total = await experiencia_profissional_1.default.find(filterObj).count();
        const experienciasProfissionais = await experiencia_profissional_1.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .sort({
            anoTermino: -1,
            mesTermino: -1,
            anoInicio: -1,
            mesInicio: -1,
        });
        for (const experienciaProfissional of experienciasProfissionais) {
            if (experienciaProfissional.anexo)
                experienciaProfissional.anexo = await (0, aws_1.getURL)(experienciaProfissional.anexo);
        }
        experienciasProfissionais.sort((a, b) => {
            if (a.actual === true && b.actual === false) {
                return -1;
            }
            else if (a.actual === false && b.actual === true) {
                return 1;
            }
            return 0;
        });
        res.status(200).json({
            msg: 'Sucesso',
            experienciasProfissionais: experienciasProfissionais,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getExperienciasProfissionaisByMembro = getExperienciasProfissionaisByMembro;
// Metodo que busca experienciaProfissional pelo id
const getExperienciaProfissional = async (req, res, next) => {
    try {
        const { id } = req.params;
        const experienciaProfissional = await experiencia_profissional_1.default.findById(id);
        if (!experienciaProfissional) {
            const error = new Error('Experiência profissional não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (experienciaProfissional.anexo) {
            experienciaProfissional.anexo = await (0, aws_1.getURL)(experienciaProfissional.anexo);
        }
        res.status(200).json({
            msg: 'Sucesso',
            experienciaProfissional: experienciaProfissional,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getExperienciaProfissional = getExperienciaProfissional;
const editExperienciaProfissional = async (req, res, next) => {
    try {
        const { id, instituicao, mesInicio, anoInicio, mesTermino, anoTermino, cargo, descricao, actual, tel1, tel2, email, fax, rua, bairro, municipio, provincia, } = req.body;
        const experienciaProfissional = await experiencia_profissional_1.default.findById(id);
        if (!experienciaProfissional) {
            const error = new Error('Experiência profissional não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(instituicao)) {
            experienciaProfissional.instituicao = instituicao;
        }
        if (Boolean(mesInicio)) {
            experienciaProfissional.mesInicio = mesInicio;
        }
        if (Boolean(anoInicio)) {
            experienciaProfissional.anoInicio = anoInicio;
        }
        if (Boolean(mesTermino)) {
            experienciaProfissional.mesTermino = mesTermino;
        }
        if (Boolean(anoTermino)) {
            experienciaProfissional.anoTermino = anoTermino;
        }
        if (Boolean(cargo)) {
            experienciaProfissional.cargo = cargo;
        }
        if (Boolean(descricao)) {
            experienciaProfissional.descricao = descricao;
        }
        if (Boolean(actual)) {
            experienciaProfissional.actual = actual;
            if (JSON.parse(actual)) {
                await experiencia_profissional_1.default.findOneAndUpdate({ actual: true }, // Query
                { actual: false }, // Update
                { new: true, useFindAndModify: false });
            }
        }
        if (Boolean(tel1)) {
            experienciaProfissional.tel1 = tel1;
        }
        if (Boolean(tel2)) {
            experienciaProfissional.tel2 = tel2;
        }
        if (Boolean(fax)) {
            experienciaProfissional.fax = fax;
        }
        // if (Boolean(rua)) {
        //   experienciaProfissional.rua = rua;
        // }
        if (Boolean(bairro)) {
            experienciaProfissional.bairro = bairro;
        }
        if (Boolean(municipio)) {
            experienciaProfissional.municipio = municipio;
        }
        if (Boolean(provincia)) {
            experienciaProfissional.provincia = provincia;
        }
        if (Boolean(email)) {
            experienciaProfissional.email = email;
        }
        await experienciaProfissional.save();
        if (experienciaProfissional.anexo) {
            experienciaProfissional.anexo = await (0, aws_1.getURL)(experienciaProfissional.anexo);
        }
        res.status(201).json({
            msg: 'Sucesso',
            experienciaProfissional,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.editExperienciaProfissional = editExperienciaProfissional;
const deletePermante = async (req, res, next) => {
    try {
        const { id } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const experienciaProfissional = await experiencia_profissional_1.default.findById(id);
        if (!experienciaProfissional) {
            const error = new Error(`Experiência profissional não encontrada!`);
            error.statusCode = 422;
            throw error;
        }
        experienciaProfissional.anexo &&
            (await (0, aws_1.deleteFile)(experienciaProfissional.anexo));
        await experiencia_profissional_1.default.deleteOne({ _id: id });
        res.status(204).json({
            msg: 'Deletado com sucesso',
        });
    }
    catch (error) {
        next(error);
    }
};
exports.deletePermante = deletePermante;
