"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHistoricoActividade = exports.getHistoricoActividades = void 0;
const aws_1 = require("../util/aws");
const historico_actividade_1 = __importDefault(require("../models/historico-actividade"));
const validate_url_1 = __importDefault(require("../util/validate-url"));
const pagination_1 = require("../util/pagination");
const main_1 = require("../util/main");
const getHistoricoActividades = async (req, res, next) => {
    try {
        let { status, userId, action, cnp, mes, semana, ano } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = {};
        if (Boolean(status)) {
            filterObject.status = status;
        }
        if (Boolean(userId)) {
            filterObject.user = userId;
        }
        if (Boolean(action)) {
            filterObject.action = action;
        }
        if (Boolean(cnp)) {
            filterObject.cnp = JSON.parse(cnp);
        }
        if (Boolean(ano)) {
            const newAno = parseInt(ano);
            filterObject.createdAt = (0, main_1.filterByYear)(newAno);
        }
        if (Boolean(ano) && Boolean(mes) && !Boolean(semana)) {
            const newAno = parseInt(ano);
            const newMes = parseInt(mes) - 1;
            filterObject.createdAt = (0, main_1.filterByMonth)(newAno, newMes);
        }
        if (Boolean(ano) && Boolean(semana) && !Boolean(mes)) {
            const newAno = parseInt(ano);
            const newWeek = parseInt(semana);
            filterObject.createdAt = (0, main_1.filterByWeek)(newAno, newWeek);
        }
        const total = await historico_actividade_1.default.find(filterObject).count();
        let historicoActividades = await historico_actividade_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'user',
            populate: {
                path: 'dadosPessoais',
            },
        })
            .sort({ createdAt: -1 });
        for (const ha of historicoActividades) {
            const userAdmin = ha.user;
            const dadosPessoais = userAdmin === null || userAdmin === void 0 ? void 0 : userAdmin.dadosPessoais;
            if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL)) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            historicoActividades,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getHistoricoActividades = getHistoricoActividades;
// Controller para buscar historicoActividade pelo id
const getHistoricoActividade = async (req, res, next) => {
    try {
        const { id } = req.params;
        const historicoActividade = await historico_actividade_1.default.findById(id).populate({
            path: 'user',
            populate: {
                path: 'dadosPessoais',
            },
        });
        if (!historicoActividade) {
            const error = new Error('Histórico de actividade não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const userAdmin = historicoActividade.user;
        const dadosPessoais = userAdmin === null || userAdmin === void 0 ? void 0 : userAdmin.dadosPessoais;
        if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL)) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', historicoActividade });
    }
    catch (err) {
        next(err);
    }
};
exports.getHistoricoActividade = getHistoricoActividade;
