"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.restoreMembro = exports.deleteMembro = exports.changeDireccao = exports.alteracaoCarteira = exports.confirmActualizacaoDadosMembro = exports.searchMembroBi = exports.editDoc = exports.approveFinal = exports.getAnoConclusaoFromExcel = exports.insertFromExcel = exports.becomePresidente = exports.addEspecialidade = exports.searchByNumeroInscricao = exports.searchAll = exports.search = exports.searchByCarteira = exports.getCV = exports.getMembro = exports.changeMembroStatus = exports.getMembrosCampanha = exports.getMembros = exports.registerMembro = exports.generateMembroInscricao = void 0;
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const observacao_1 = __importDefault(require("../models/observacao"));
const aws_1 = require("../util/aws");
const express_validator_1 = require("express-validator");
const membro_1 = __importStar(require("../models/membro"));
const presidente_1 = __importDefault(require("../models/presidente"));
const user_1 = __importDefault(require("../models/user"));
const validate_url_1 = __importDefault(require("../util/validate-url"));
const pagination_1 = require("../util/pagination");
const mandato_1 = __importDefault(require("../models/mandato"));
const main_1 = require("../util/main");
const experiencia_profissional_1 = __importDefault(require("../models/experiencia-profissional"));
const formacao_academica_1 = __importDefault(require("../models/formacao-academica"));
const counter_1 = __importDefault(require("../models/counter"));
const file_1 = require("../util/file");
const verification_code_1 = __importDefault(require("../util/verification-code"));
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const stream_1 = require("stream");
const readline_1 = __importDefault(require("readline"));
const dados_academico_1 = __importDefault(require("../models/dados-academico"));
const financa_1 = require("../util/financa");
const membro_docs_1 = require("../types/membro-docs");
const carteira_1 = __importDefault(require("../models/carteira"));
const date_fns_1 = require("date-fns");
const emolumento_1 = __importDefault(require("../models/emolumento"));
const proxypay_1 = require("../services/proxypay");
const postmark_1 = __importDefault(require("../services/postmark"));
// Metodo para gerar numero de inscricao do membro
const generateMembroInscricao = async (direccao) => {
    const membroCounterId = direccao === 'OFA' ? 'MembroCounterOFA' : 'MembroCounterCAPFA';
    const counter = await counter_1.default.findOneAndUpdate({ id: membroCounterId }, { $inc: { seq: 1 } }, { new: true, upsert: true });
    const numeroInscricao = direccao === 'OFA' ? `OFA${counter.seq}` : `CAPFA${counter.seq}`;
    return numeroInscricao;
};
exports.generateMembroInscricao = generateMembroInscricao;
const registerMembro = async (req, res, next) => {
    var _a;
    try {
        // Arquivo para upload
        const { foto, copiaBI, diplomaCertificado, declaracaoInares } = req.files;
        const { direccao, nome, genero, dataNascimento, estadoCivil, provincia, municipio, bairro, rua, provinciaNasc, municipioNasc, nacionalidade, nomePai, nomeMae, telefone1, telefone2, email, 
        // Dados do local de trabalho
        instituicao, funcao, emailInstituicao, tel1Instituicao, tel2Instiuicao, faxInstiuicao, ruaInstituicao, bairroInstituicao, municipioInstituicao, provinciaInstituicao, sector, 
        // Dados Academicos
        cursoLincenciatura, universidadeLicenciatura, anoConclusaoLicenciatura, cidadeLicenciatura, paisLicenciatura, cursoPosGraduacao, universidadePosGraduacao, anoConclusaoPosGraduacao, cidadePosGraduacao, paisPosGraduacao, cursoMestrado, universidadeMestrado, anoConclusaoMestrado, cidadeMestrado, paisMestrado, cursoEspecialidade, universidadeEspecialidade, anoConclusaoEspecialidade, cidadeEspecialidade, paisEspecialidade, cursoDoutoramento, universidadeDoutoramento, anoConclusaoDoutoramento, cidadeDoutoramento, paisDoutoramento, cursoTecnicoMedio, instituicaoTecnicoMedio, anoConclusaoTecnicoMedio, cidadeTecnicoMedio, paisTecnicoMedio, cursoBacharel, instituicaoBacharel, anoConclusaoBacharel, cidadeBacharel, paisBacharel, 
        // Remover quando o jonilson Fixar no Front
        cursoBaixarel, instituicaoBaixarel, anoConclusaoBaixarel, cidadeBaixarel, paisBaixarel, 
        // Remover quando o jonilson Fixar no Front
        cursoTecnicoBasico, instituicaoTecnicoBasico, anoConclusaoTecnicoBasico, cidadeTecnicoBasico, paisTecnicoBasico, 
        // Secretaria
        // Pagamento
        emolumentoId, userId, } = req.body;
        let bi = req.body.bi;
        bi = bi.toUpperCase();
        const errors = (0, express_validator_1.validationResult)(req);
        let admin;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!foto) {
            const error = new Error(`Faça o upload da foto!`);
            error.statusCode = 422;
            throw error;
        }
        if (!copiaBI) {
            const error = new Error(`Faça o upload da cópia do BI!`);
            error.statusCode = 422;
            throw error;
        }
        if (!diplomaCertificado) {
            const error = new Error(`Faça o upload do diploma ou certificado!`);
            error.statusCode = 422;
            throw error;
        }
        if (!declaracaoInares) {
            const error = new Error(`Faça o upload da Declaracao do INARES!`);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error(`Admin não encontrado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        const foundEmail = await dados_pessoais_1.default.findOne({
            email: email,
        });
        const foundUserWithEmail = await user_1.default.findOne({
            email: email,
        });
        if (foundEmail || foundUserWithEmail) {
            const error = new Error(`O email '${email}' já está sendo usado`);
            error.statusCode = 422;
            throw error;
        }
        const foundTel1 = await dados_pessoais_1.default.findOne({
            telefone1: telefone1,
        });
        if (foundTel1) {
            const error = new Error(`O número de telefone '${telefone1}' já está sendo usado`);
            error.statusCode = 422;
            throw error;
        }
        const foundBI = await dados_pessoais_1.default.findOne({ bi: bi });
        if (foundBI) {
            const error = new Error(`O número do BI '${bi}' já está sendo usado!`);
            error.statusCode = 422;
            throw error;
        }
        const emolumento = await emolumento_1.default.findById(emolumentoId);
        if (!emolumento) {
            const error = new Error('Emolumento não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (!emolumento.designacao.includes('Taxa')) {
            const error = new Error('Emolumento inválido!');
            error.statusCode = 422;
            throw error;
        }
        // Ronomeia a foto
        foto[0].filename = (0, file_1.generateFileName)(foto[0]);
        const dadosPessoais = new dados_pessoais_1.default({
            nome,
            dataNascimento,
            estadoCivil,
            genero,
            nomePai,
            nomeMae,
            email,
            telefone1,
            telefone2,
            bi,
            provincia,
            municipio,
            bairro,
            rua,
            provinciaNasc,
            municipioNasc,
            nacionalidade,
            perfil: 'Farmacêutico(a)',
            fotoURL: foto && foto[0].filename,
        });
        await dadosPessoais.save();
        // Metodo para gerar numero de inscricaoDo membro
        const numeroInscricao = await (0, exports.generateMembroInscricao)(direccao);
        // Renomeia os documentos
        copiaBI[0].filename = (0, file_1.generateFileName)(copiaBI[0]);
        diplomaCertificado[0].filename = (0, file_1.generateFileName)(diplomaCertificado[0]);
        declaracaoInares[0].filename = (0, file_1.generateFileName)(declaracaoInares[0]);
        const membro = new membro_1.default({
            direccao,
            nome: dadosPessoais.nome,
            genero: dadosPessoais.genero,
            dadosPessoais: dadosPessoais,
            delegacao: provincia,
            numeroInscricao,
            provincia,
            docs: {
                copiaBI: copiaBI[0].filename,
                diplomaCertificado: diplomaCertificado[0].filename,
                declaracaoInares: declaracaoInares[0].filename,
            },
        });
        if (Boolean(userId)) {
            membro.online = false;
            membro.admin = userId;
        }
        await membro.save();
        // Experiencia profissional
        const experienciaProfissional = new experiencia_profissional_1.default({
            instituicao,
            sector,
            cargo: funcao,
            email: emailInstituicao,
            tel1: tel1Instituicao,
            rua: ruaInstituicao,
            bairro: bairroInstituicao,
            municipio: municipioInstituicao,
            provincia: provinciaInstituicao,
            actual: true,
            membro,
        });
        if (Boolean(tel2Instiuicao)) {
            experienciaProfissional.tel2 = tel2Instiuicao;
        }
        if (Boolean(faxInstiuicao)) {
            experienciaProfissional.fax = faxInstiuicao;
        }
        await experienciaProfissional.save();
        // Dados Academicos OFA
        // Licenciatura
        let licenciatura;
        if (cursoLincenciatura) {
            licenciatura = await dados_academico_1.default.create({
                tipo: 'Licenciatura',
                instituicao: universidadeLicenciatura,
                curso: cursoLincenciatura,
                anoFim: anoConclusaoLicenciatura,
                cidade: cidadeLicenciatura,
                pais: paisLicenciatura,
                membro,
            });
        }
        // PosGraduacao
        let posGraduacao;
        if (cursoPosGraduacao) {
            posGraduacao = await dados_academico_1.default.create({
                tipo: 'Pós-Graduação',
                instituicao: universidadePosGraduacao,
                curso: cursoPosGraduacao,
                anoFim: anoConclusaoPosGraduacao,
                cidade: cidadePosGraduacao,
                pais: paisPosGraduacao,
                membro,
            });
        }
        // Mestrado
        let mestrado;
        if (cursoMestrado) {
            mestrado = await dados_academico_1.default.create({
                tipo: 'Mestrado',
                instituicao: universidadeMestrado,
                curso: cursoMestrado,
                anoFim: anoConclusaoMestrado,
                cidade: cidadeMestrado,
                pais: paisMestrado,
                membro,
            });
        }
        // Especialidade
        let especialidade;
        if (cursoEspecialidade) {
            especialidade = await dados_academico_1.default.create({
                tipo: 'Especialidade',
                instituicao: universidadeEspecialidade,
                curso: cursoEspecialidade,
                anoFim: anoConclusaoEspecialidade,
                cidade: cidadeEspecialidade,
                pais: paisEspecialidade,
                membro,
            });
        }
        // Doutoramento
        let doutoramento;
        if (cursoDoutoramento) {
            doutoramento = await dados_academico_1.default.create({
                tipo: 'Doutoramento',
                instituicao: universidadeDoutoramento,
                curso: cursoDoutoramento,
                anoFim: anoConclusaoDoutoramento,
                cidade: cidadeDoutoramento,
                pais: paisDoutoramento,
                membro,
            });
        }
        // Dados Academicos CAPFA
        //  cursoTecnicoMedio
        let tecnicoMedio;
        if (cursoTecnicoMedio) {
            doutoramento = await dados_academico_1.default.create({
                tipo: 'Técnico-Médio',
                instituicao: instituicaoTecnicoMedio,
                curso: cursoTecnicoMedio,
                anoFim: anoConclusaoTecnicoMedio,
                cidade: cidadeTecnicoMedio,
                pais: paisTecnicoMedio,
                membro,
            });
        }
        // cursoBacherel
        let bacharel;
        if (cursoBacharel) {
            doutoramento = await dados_academico_1.default.create({
                tipo: 'Bacharel',
                instituicao: instituicaoBacharel,
                curso: cursoBacharel,
                anoFim: anoConclusaoBacharel,
                cidade: cidadeBacharel,
                pais: paisBacharel,
                membro,
            });
        }
        // cursoBaixarel - Remover quando on Jonilson fizer a implementacao
        let baixarel;
        if (cursoBaixarel) {
            doutoramento = await dados_academico_1.default.create({
                tipo: 'Baixarel',
                instituicao: instituicaoBaixarel,
                curso: cursoBaixarel,
                anoFim: anoConclusaoBaixarel,
                cidade: cidadeBaixarel,
                pais: paisBaixarel,
                membro,
            });
        }
        // cursoBaixarel - Remover quando on Junilson fizer a implementacao
        // cursoTecnicoBasico
        let tecnicoBasico;
        if (cursoTecnicoBasico) {
            doutoramento = await dados_academico_1.default.create({
                tipo: 'Técnico-Básico',
                instituicao: instituicaoTecnicoBasico,
                curso: cursoTecnicoBasico,
                anoFim: anoConclusaoTecnicoBasico,
                cidade: cidadeTecnicoBasico,
                pais: paisTecnicoBasico,
                membro,
            });
        }
        // Upload da foto
        await (0, aws_1.uploadFile)(foto[0]);
        // Upload dos documentos
        await (0, aws_1.uploadFile)(copiaBI[0]);
        await (0, aws_1.uploadFile)(diplomaCertificado[0]);
        await (0, aws_1.uploadFile)(declaracaoInares[0]);
        // console.log('Passou');
        // Payment
        const dataExpiracao = (0, date_fns_1.addDays)(new Date((0, main_1.getAngolaTime)()), 3);
        const pagamento = await (0, financa_1.generateReference)(emolumento, membro.dadosPessoais, dataExpiracao, {
            // campo costomizavel para model pagamento
            membroId: membro.id,
            emolumentoId: emolumento.id,
        });
        await postmark_1.default.sendEmail({
            To: membro.dadosPessoais.email,
            From: process.env.SENDER_EMAIL,
            Subject: 'Inscrição na  OFA | CAPFA',
            HtmlBody: `<h1>Estado da Inscrição na OFA | CAPFA</h1>
        <p>
          A sua inscrição foi realizada com sucesso seu número 
          de inscrição é: <b>${membro.numeroInscricao}</b> e seu processo 
          está <b>${membro.numeroInscricao}</b>.
        </p>

        <p>
          Deverá efetuar o pagamento da taxa de Inscrição, atraves 
          do ATM ou Multicaixa Express, segue  a baixo os dados de pagamento:
        </p>

        <p><b>Referência:</b> ${pagamento.ref}</p>
        <p><b>Entidate:</b> ${proxypay_1.entidadePagamento}</p>
        <p>O valor da Inscrição é ${emolumento.valor} kz</p>
        <p>Referência válida até ${(_a = pagamento === null || pagamento === void 0 ? void 0 : pagamento.referencia) === null || _a === void 0 ? void 0 : _a.dataExpiracao.toLocaleString()}</p>

        <p>
          Poderá acompanhar o estado da sua inscrição no consultor de processo 
          do site <a href="https://www.ofa.ao/">www.ofa.ao</a> usando o seu número de inscrição. 
        </p>

        <p><b>Nota:</b> Este e-mail foi gerado automaticamente pela plataforma <b>CNP - OFA | CAPFA</b></p>
      `,
            MessageStream: 'outbound',
        });
        if (admin) {
            await (0, main_1.createHistoricoActividade)('Inscreveu membro', 'Membro', membro.id, admin);
        }
        res.status(201).json({
            msg: 'Sucesso',
            membro,
            experienciaProfissional,
            licenciatura,
            posGraduacao,
            mestrado,
            especialidade,
            doutoramento,
            pagamento,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.registerMembro = registerMembro;
// Controller que busca membros em geral
const getMembros = async (req, res, next) => {
    var _a;
    try {
        let { status, perfil, delegacao, campanha, approved, genero, provincia, onlyDeleted, withDeleted } = req.query;
        let direccao = Array.isArray(req.query.direccao)
            ? req.query.direccao[0]
            : req.query.direccao;
        direccao = typeof direccao === 'string' ? direccao : '';
        const page = (0, pagination_1.getPage)(req.query.page);
        let perPage = 50;
        let paramPerPage = req.query.perPage;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = { cnp: { $ne: true } };
        // Object que define se vai apresentar os deletados
        let overrideDeletedObject = { overrideDeleted: false };
        if (direccao && !['CNP', 'Coordenador', 'Bastónario'].includes(direccao)) {
            filterObject.direccao = direccao;
        }
        if (Boolean(status)) {
            filterObject.status = status;
        }
        if (Boolean(provincia)) {
            filterObject.provincia = provincia;
        }
        if (Boolean(perfil)) {
            filterObject.perfil = perfil;
        }
        if (Boolean(delegacao)) {
            filterObject.delegacao = delegacao;
        }
        if (Boolean(approved)) {
            filterObject.approved = approved;
        }
        if (Boolean(campanha)) {
            filterObject.campanha = campanha;
        }
        if (Boolean(genero)) {
            filterObject.genero = genero;
        }
        if (Boolean(withDeleted) && JSON.parse(withDeleted)) {
            overrideDeletedObject.overrideDeleted = true;
        }
        if (Boolean(onlyDeleted) && JSON.parse(onlyDeleted)) {
            filterObject.deletedAt = { $ne: null };
            overrideDeletedObject.overrideDeleted = true;
        }
        const total = await membro_1.default.find(filterObject).setOptions(overrideDeletedObject).count();
        let membros = await membro_1.default.find(filterObject).setOptions(overrideDeletedObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'dadosPessoais',
        })
            .populate({
            path: 'despachoPor',
            populate: 'dadosPessoais',
        })
            .sort((0, main_1.sortBy)(req.query.sortBy || 'anoConlusao:ASC'));
        for (const membro of membros) {
            const dadosPessoais = membro.dadosPessoais;
            const dadosAdmin = (_a = membro === null || membro === void 0 ? void 0 : membro.despachoPor) === null || _a === void 0 ? void 0 : _a.dadosPessoais;
            if (dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
            if ((dadosAdmin === null || dadosAdmin === void 0 ? void 0 : dadosAdmin.fotoURL) && !(0, validate_url_1.default)(dadosAdmin === null || dadosAdmin === void 0 ? void 0 : dadosAdmin.fotoURL)) {
                dadosAdmin.fotoURL = await (0, aws_1.getURL)(dadosAdmin.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            membros: membros,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getMembros = getMembros;
// Controller que busca membros que actualizaram os dados na campanha
const getMembrosCampanha = async (req, res, next) => {
    try {
        let { status, perfil, conselheiro, campanha } = req.query;
        let direccao = Array.isArray(req.query.direccao)
            ? req.query.direccao[0]
            : req.query.direccao;
        direccao = typeof direccao === 'string' ? direccao : '';
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = { cnp: { $ne: true }, campanha: true, direccao };
        if (direccao && !['CNP', 'Coordenador', 'Bastónario'].includes(direccao)) {
            filterObject.direccao = direccao;
        }
        if (Boolean(status)) {
            filterObject.status = status;
        }
        if (Boolean(perfil)) {
            filterObject.perfil = perfil;
        }
        if (Boolean(conselheiro)) {
            filterObject.conselheiro = true;
        }
        if (Boolean(campanha)) {
            filterObject.campanha = campanha;
        }
        const total = await membro_1.default.find(filterObject).count();
        const membros = await membro_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'dadosPessoais',
        })
            .sort({ dataCampanha: -1 });
        for (const membro of membros) {
            const dadosPessoais = membro.dadosPessoais;
            if (dadosPessoais) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            membros: membros,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getMembrosCampanha = getMembrosCampanha;
const changeMembroStatus = async (req, res, next) => {
    try {
        const { id, status, observacao, userId, assunto } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!membro_1.membroStatus.includes(status)) {
            const error = new Error('Status inválido!');
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(id).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        membro.status = status;
        membro.dataDespacho = new Date();
        membro.despachoPor = admin;
        await membro.save();
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais)
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
        let createdObs;
        if (Boolean(observacao)) {
            const obs = new observacao_1.default({
                assunto: assunto,
                para: membro.id,
                observacao,
                de: userId,
            });
            createdObs = await obs.save();
        }
        let action = (0, main_1.getActividadeAction)(status);
        await (0, main_1.createHistoricoActividade)(action, 'Membro', id, admin);
        if (membro.status === 'Reprovado') {
            await postmark_1.default.sendEmail({
                To: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
                From: process.env.SENDER_EMAIL,
                Subject: 'Processo Indeferido',
                HtmlBody: `<h1>Seu processo na ${membro.direccao} foi indeferido</h1>
          <h3>Observação:</h3>   
          <p>
           ${observacao}
          </p>

          <p>Entre em contacto com a direccao para mais detalhes ${membro.direccao}</p>
  
          <p>Este e-mail foi gerado automaticamente pela plataforma <b>CNP - CRL</b></p>
        `,
                MessageStream: 'outbound',
            });
        }
        res.status(201).json({ msg: 'Sucesso', membro });
    }
    catch (error) {
        next(error);
    }
};
exports.changeMembroStatus = changeMembroStatus;
// Controller para buscar membro pelo id
const getMembro = async (req, res, next) => {
    // console.log(req.params)
    var _a;
    try {
        const { id } = req.params;
        const { carteira } = req.query;
        const membro = await membro_1.default.findById(id).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        (0, main_1.getDocsURL)(membro);
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        if (!!carteira) {
            const imageData = Buffer.from(dadosPessoais.fotoURL, 'binary').toString('base64');
            dadosPessoais.fotoURL = imageData;
        }
        const observacoes = await observacao_1.default.find({
            para: membro.id,
        }).populate({
            path: 'de',
            select: 'dadosPessoais -_id',
            populate: {
                path: 'dadosPessoais',
                select: 'nome telefone1 email fotoURL genero  -_id',
            },
        });
        for (let obs of observacoes) {
            if (obs) {
                const dadosPessoais = (_a = obs.de) === null || _a === void 0 ? void 0 : _a.dadosPessoais;
                if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais.fotoURL)) {
                    dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
                }
            }
        }
        res.status(200).json({ msg: 'Sucesso', membro, observacoes });
    }
    catch (err) {
        next(err);
    }
};
exports.getMembro = getMembro;
// Controller para pegar o Curriculo de um membro
const getCV = async (req, res, next) => {
    try {
        const { id } = req.params;
        const membro = await membro_1.default.findById(id).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        (0, main_1.getDocsURL)(membro);
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        // Experiencia Profissional
        const experienciasProfissionais = await experiencia_profissional_1.default.find({
            membro: id,
        }).sort({
            anoTermino: -1,
            mesTermino: -1,
            anoInicio: -1,
            mesInicio: -1,
        });
        for (const experienciaProfissional of experienciasProfissionais) {
            if (experienciaProfissional.anexo)
                experienciaProfissional.anexo = await (0, aws_1.getURL)(experienciaProfissional.anexo);
        }
        experienciasProfissionais.sort((a, b) => {
            if (a.actual === true && b.actual === false) {
                return -1;
            }
            else if (a.actual === false && b.actual === true) {
                return 1;
            }
            return 0;
        });
        // Formacao Academicas
        const formacoesAcademicas = await formacao_academica_1.default.find({
            membro: id,
        }).sort({ anoTermino: -1, mesTermino: -1 });
        for (const formacaoAcademica of formacoesAcademicas) {
            if (formacaoAcademica.anexo)
                formacaoAcademica.anexo = await (0, aws_1.getURL)(formacaoAcademica.anexo);
        }
        res.status(200).json({
            msg: 'Sucesso',
            membro,
            experienciasProfissionais,
            formacoesAcademicas,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getCV = getCV;
// Controller para pesquisar membro pela carteira
const searchByCarteira = async (req, res, next) => {
    try {
        const { search } = req.body;
        const verificacao = await dados_pessoais_1.default.findOne({ bi: search });
        if (!verificacao) {
            const error = new Error(`Usuário não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        // const membro = await Membro.findOne({ dadosPessoais: verificacao._id });
        const membro = await membro_1.default.findOne({
            // numeroCarteira: search.toUpperCase(),
            dadosPessoais: verificacao._id,
            status: 'Activo',
            cnp: { $ne: true },
        }).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (membro && !membro.campanha) {
            // const error: IError = new Error('Dados desactualizados!');
            // error.statusCode = 422;
            // throw   error ;
            return res
                .status(422)
                .json({ message: 'Dados desactualizados!', membro });
        }
        // getDocsURL(membro);
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', membro });
    }
    catch (err) {
        next(err);
    }
};
exports.searchByCarteira = searchByCarteira;
// CNP Busca - busca membro pela carteira e pelo nome profissional
const search = async (req, res, next) => {
    var _a;
    try {
        let { search } = req.body;
        search = search.toUpperCase();
        const regex = /^\d+OFA\d{4}$/;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 10;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let membros = [];
        let total = 0;
        if (regex.test(search) ||
            search.includes('OFA') ||
            search.includes('CAPFA')) {
            const membro = await membro_1.default.findOne({
                numeroCarteira: search,
                status: 'Activo',
                cnp: { $ne: true },
            }).populate({
                path: 'dadosPessoais',
            });
            if (!membro) {
                const error = new Error('Membro não encontrado!');
                error.statusCode = 422;
                throw error;
            }
            (0, main_1.getDocsURL)(membro);
            const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
            if (dadosPessoais) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
            if (membro) {
                membros.push(membro);
            }
        }
        else {
            const pipeline = [
                {
                    $search: {
                        index: 'default',
                        text: {
                            query: search,
                            path: 'nome',
                            fuzzy: {
                                maxEdits: 2,
                            },
                        },
                    },
                },
            ];
            total = (_a = (await membro_1.default.aggregate(pipeline).count('count'))[0]) === null || _a === void 0 ? void 0 : _a.count;
            const membrosPipeline = await membro_1.default.aggregate(pipeline)
                .skip((0, pagination_1.skip)(page, perPage))
                .limit(perPage);
            for (let mb of membrosPipeline) {
                const membro = await membro_1.default.findOne({
                    _id: mb._id,
                    status: 'Activo',
                    cnp: { $ne: true },
                }).populate({
                    path: 'dadosPessoais',
                });
                if (membro) {
                    (0, main_1.getDocsURL)(membro);
                    const dadosPessoais = membro.dadosPessoais;
                    if (dadosPessoais) {
                        dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
                    }
                    membros.push(membro);
                }
            }
        }
        if (membros.length === 0) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({
            msg: 'Sucesso',
            membros,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.search = search;
const searchAll = async (req, res, next) => {
    var _a;
    try {
        let { search } = req.body;
        search = search.toUpperCase();
        const regex = /^\d+OFA\d{4}$/;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 10;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let membros = [];
        let total = 0;
        if (regex.test(search) ||
            search.includes('OFA') ||
            search.includes('CAPFA')) {
            const membro = await membro_1.default.findOne({
                numeroCarteira: search,
                cnp: { $ne: true },
            }).populate({
                path: 'dadosPessoais',
            });
            if (!membro) {
                const error = new Error('Membro não encontrado!');
                error.statusCode = 422;
                throw error;
            }
            (0, main_1.getDocsURL)(membro);
            const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
            if (dadosPessoais) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
            if (membro) {
                membros.push(membro);
            }
        }
        else {
            const pipeline = [
                {
                    $search: {
                        index: 'default',
                        text: {
                            query: search,
                            path: 'nome',
                            fuzzy: {
                                maxEdits: 2,
                            },
                        },
                    },
                },
            ];
            total = (_a = (await membro_1.default.aggregate(pipeline).count('count'))[0]) === null || _a === void 0 ? void 0 : _a.count;
            const membros = await membro_1.default.aggregate(pipeline)
                .skip((0, pagination_1.skip)(page, perPage))
                .limit(perPage);
            for (let mb of membros) {
                const membro = await membro_1.default.findOne({
                    _id: mb._id,
                    cnp: { $ne: true },
                }).populate({
                    path: 'dadosPessoais',
                });
                if (membro) {
                    (0, main_1.getDocsURL)(membro);
                    const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
                    if (dadosPessoais) {
                        dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
                    }
                    membros.push(membro);
                }
            }
        }
        if (membros.length === 0) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({
            msg: 'Sucesso',
            membros,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.searchAll = searchAll;
// Funcao que busca um candidato pelo numero de inscricao no Site da Ordem
const searchByNumeroInscricao = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        // const { numeroInscricao } = req.body;
        let numeroInscricao = req.body.numeroInscricao;
        numeroInscricao = numeroInscricao.toUpperCase();
        let observacoes;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findOne({ numeroInscricao }).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Processo não encontrado');
            error.statusCode = 422;
            throw error;
        }
        (0, main_1.getDocsURL)(membro);
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        observacoes = await observacao_1.default.find({
            para: membro.id,
        }).populate({
            path: 'de',
            populate: {
                path: 'dadosPessoais',
            },
        });
        for (let obs of observacoes) {
            if (obs) {
                const admin = obs.de;
                if (admin) {
                    const dadosPessoais = admin.dadosPessoais;
                    if (dadosPessoais.fotoURL && !(0, validate_url_1.default)(dadosPessoais.fotoURL)) {
                        dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
                    }
                }
            }
        }
        res.status(200).json({ msg: 'Sucesso', membro, observacoes });
    }
    catch (err) {
        next(err);
    }
};
exports.searchByNumeroInscricao = searchByNumeroInscricao;
const addEspecialidade = async (req, res, next) => {
    try {
        const { membroId, userId, especialidade } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        let admin;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrado!');
                error.statusCode = 422;
                throw error;
            }
        }
        const membro = await membro_1.default.findById(membroId).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        membro.especialidade = especialidade;
        await membro.save();
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais.fotoURL) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        if (admin) {
            let action = 'Adicionou especialidade';
            if (especialidade === '' || especialidade === undefined) {
                action = 'Removeu especialidade';
            }
            await (0, main_1.createHistoricoActividade)(action, 'Membro', membroId, admin);
        }
        res.status(201).json({ msg: 'Sucesso', membro });
    }
    catch (error) {
        next(error);
    }
};
exports.addEspecialidade = addEspecialidade;
// Metodo para tornar membro presidente
const becomePresidente = async (req, res, next) => {
    try {
        const { membroId, inicioMandato, fimMandato } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId).populate('dadosPessoais');
        if (!membro) {
            const error = new Error(`Membro não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        if (membro.perfil !== 'Membro(a)') {
            const error = new Error(`Membro ${membro.perfil} não pode se tornar presidente!`);
            error.statusCode = 422;
            throw error;
        }
        const dadosAntigosPR = await dados_pessoais_1.default.find({
            perfil: 'Presidente',
        });
        for (let dadosPR of dadosAntigosPR) {
            dadosPR.perfil = 'Membro(a)';
            await dadosPR.save();
            const userPR = await user_1.default.findOne({ dadosPessoais: dadosPR.id });
            if (userPR) {
                userPR.status = 'Inactivo';
                await userPR.save();
            }
        }
        const dadosPessoais = await dados_pessoais_1.default.findById(membro.dadosPessoais);
        if (dadosPessoais) {
            dadosPessoais.perfil = 'Presidente';
            await dadosPessoais.save();
        }
        let presidente;
        let user;
        let mandato;
        presidente = await presidente_1.default.findOne({ membro: membroId });
        if (presidente) {
            // Se já foi presidente passa por aqui
            presidente.actual = true;
            await presidente.save();
            user = await user_1.default.findOne({
                email: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
                dadosPessoais: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.id,
            });
            if (user) {
                user.status = 'Activo';
                await user.save();
            }
            if (Boolean(inicioMandato) && Boolean(fimMandato)) {
                mandato = await mandato_1.default.create({
                    inicioMandato,
                    fimMandato,
                    presidente: presidente.id,
                });
            }
        }
        else {
            // Se ainda não foi presidente passa por aqui
            const userMembro = await user_1.default.findOne({
                membro: membroId,
                email: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
            });
            presidente = new presidente_1.default({
                membro: membroId,
                actual: true,
            });
            await presidente.save();
            user = new user_1.default({
                email: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
                funcao: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.perfil,
                password: userMembro === null || userMembro === void 0 ? void 0 : userMembro.password,
                codigoVerificao: userMembro === null || userMembro === void 0 ? void 0 : userMembro.codigoVerificao,
                dadosPessoais: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.id,
                tipo: 'Admin',
            });
            await user.save();
            if (Boolean(inicioMandato) && Boolean(fimMandato)) {
                mandato = await mandato_1.default.create({
                    inicioMandato,
                    fimMandato,
                    presidente: presidente.id,
                });
            }
        }
        // const msg = {
        //   to: dadosPessoais?.email,
        //   from: process.env.SENDER_EMAIL!,
        //   subject: 'Parabéns Presidente',
        //   html: `<h1>Presidente Do Conselho Provincial de Luanda</h1>
        //     <p>
        //       A sua conta recebeu privilégios de Presidente.
        //       Agora poderá acessar o CNP Gest com as mesma
        //       credencias de membro no link a baixo
        //     </p>
        //     <a href="https://cpl.cnp.ao/login" target="_blank">https://cpl.cnp.ao/login</a>
        //   `,
        // };
        // await mailer.send(msg);
        res.status(201).json({
            msg: 'Sucesso',
            dadosPessoais,
            presidente,
            user,
            mandato,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.becomePresidente = becomePresidente;
const insertFromExcel = async (req, res, next) => {
    try {
        const file = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!file) {
            const error = new Error('Faça o upload do arquivo!');
            error.statusCode = 422;
            throw error;
        }
        const perfil = 'Farmacêutico(a)';
        const readableFile = new stream_1.Readable();
        readableFile.push(file.buffer);
        readableFile.push(null);
        const docLines = readline_1.default.createInterface({
            input: readableFile,
        });
        const dadosPessoaisArray = [];
        const experienciaProfissionais = [];
        const dadosAcademicos = [];
        const membros = [];
        // Extraindo os Dados
        let index = 0;
        for await (let line of docLines) {
            const fields = line.split(',');
            if (index > 2) {
                // ----- DadosPessoais -----
                let numeroInscricao = fields[0];
                let nome = fields[1];
                let genero = fields[2];
                let bi = fields[3];
                let nacionalidade = fields[4];
                let provincia = fields[5];
                let localTrabalho = fields[6];
                let funcao = fields[7];
                let universidade = fields[8];
                let paisFormacao = fields[9];
                let anoConclusao = fields[10];
                let outrosTitulosAcademicos = fields[11];
                let telefones = fields[12].split('/');
                let email = fields[13];
                //Pagamento
                let joia2014 = fields[15];
                let joia2015 = fields[16];
                let joia2016 = fields[17];
                let joia2017 = fields[18];
                let direcaoTecnica = fields[19];
                bi = Boolean(bi) ? bi.toUpperCase() : '';
                let telefone1 = telefones[0];
                let telefone2 = Boolean(telefones[1]) ? telefones[1] : '';
                // DadosPessoais
                let dadosPessoais = new dados_pessoais_1.default({
                    nome,
                    genero,
                    provincia,
                    perfil,
                    telefone1,
                    telefone2,
                    nacionalidade,
                    email,
                    bi,
                    fotoURL: 'user.png',
                });
                dadosPessoaisArray.push(dadosPessoais);
                // Membro
                const membro = new membro_1.default({
                    numeroInscricao: numeroInscricao,
                    numeroCarteira: numeroInscricao,
                    approved: true,
                    online: false,
                    status: 'Activo',
                    dadosPessoais,
                    joia2014,
                    joia2015,
                    joia2016,
                    joia2017,
                    direcaoTecnica,
                });
                membros.push(membro);
                // ExperienciaProfissional
                const experienciaProfissional = new experiencia_profissional_1.default({
                    instituicao: localTrabalho,
                    cargo: funcao,
                    actual: true,
                    membro,
                });
                experienciaProfissionais.push(experienciaProfissional);
                // DadosAcademicos
                const dadosAcademico = new dados_academico_1.default({
                    instituicao: universidade,
                    curso: outrosTitulosAcademicos,
                    tipo: 'Licenciatura',
                    pais: paisFormacao,
                    // anoFim: anoConclusao,
                    membro,
                });
                if (!isNaN(Number(anoConclusao))) {
                    dadosAcademico.anoFim = Number(anoConclusao);
                }
                dadosAcademicos.push(dadosAcademico);
            }
            index++;
        }
        const total = dadosPessoaisArray.length;
        // Loop para validacao
        // for (let i = 0; i < total; i++) {
        //   if (Boolean(dadosPessoaisArray[i].email)) {
        //     console.log('Analise Email: ', dadosPessoaisArray[i].email);
        //     const foundEmail = await DadosPessoais.findOne({
        //       email: dadosPessoaisArray[i].email,
        //     });
        //     const foundUserEmail = await User.findOne({
        //       email: dadosPessoaisArray[i].email,
        //     });
        //     if (foundEmail || foundUserEmail) {
        //       const error: IError = new Error(
        //         `O email '${dadosPessoaisArray[i].email}' já está sendo usado`,
        //       );
        //       error.statusCode = 422;
        //       throw error;
        //     }
        //   }
        //   if (Boolean(dadosPessoaisArray[i].telefone1)) {
        //     console.log('Analise telefone: ', dadosPessoaisArray[i].telefone1);
        //     const foundTel1 = await DadosPessoais.findOne({
        //       telefone1: dadosPessoaisArray[i].telefone1,
        //     });
        //     if (foundTel1) {
        //       const error: IError = new Error(
        //         `O número de telefone '${dadosPessoaisArray[i].telefone1}' já está sendo usado`,
        //       );
        //       error.statusCode = 422;
        //       throw error;
        //     }
        //   }
        //   if (Boolean(dadosPessoaisArray[i].bi)) {
        //     console.log('Analise BI: ', dadosPessoaisArray[i].bi);
        //     const foundBI = await DadosPessoais.findOne({
        //       bi: dadosPessoaisArray[i].bi,
        //     });
        //     if (foundBI) {
        //       const error: IError = new Error(
        //         `O número do BI '${dadosPessoaisArray[i].bi}' já está sendo usado!`,
        //       );
        //       error.statusCode = 422;
        //       throw error;
        //     }
        //   }
        //   if (Boolean(membros[i].numeroCarteira)) {
        //     console.log('Analise carteira: ', membros[i].numeroCarteira);
        //     const foundNumeroCarteira = await Membro.findOne({
        //       numeroCarteira: membros[i].numeroCarteira,
        //     });
        //     if (foundNumeroCarteira) {
        //       const error: IError = new Error(
        //         `O número de carteira '${membros[i].numeroCarteira}' já está sendo usado!`,
        //       );
        //       error.statusCode = 422;
        //       throw error;
        //     }
        //   }
        // }
        // Loop para insercao
        for (let i = 0; i < total; i++) {
            const dadosPessoais = await dados_pessoais_1.default.create(dadosPessoaisArray[i]);
            const membro = await membro_1.default.create(membros[i]);
            const esperienciaProfisional = await experiencia_profissional_1.default.create(experienciaProfissionais[i]);
            const dadosAcademico = await dados_academico_1.default.create(dadosAcademicos[i]);
            console.log('----- Membro -----');
            console.log(membro);
            console.log(dadosAcademico);
            console.log('Contagem: ', i);
            const codigoVerificao = (0, verification_code_1.default)(6);
            // const password = 'CNPUSER' + generateVerificationCode(6) + 'OFA';
            const password = 'CNPUSER86377OFA';
            const hashPassword = await bcryptjs_1.default.hash(password, 12);
            const user = new user_1.default({
                email: dadosPessoais.email,
                tipo: 'Membro',
                password: hashPassword,
                codigoVerificao,
                dadosPessoais,
                membro: membro,
            });
            await user.save();
            // let date = new Date();
            // let ano = date.getFullYear();
            // let mesInicio = date.getMonth() + 1;
            // await createManySF(ano, mesInicio, membro?.id);
        }
        res.status(201).json({
            msg: `Inseridos ${dadosPessoaisArray.length} registros com sucesso`,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.insertFromExcel = insertFromExcel;
const getAnoConclusaoFromExcel = async (req, res, next) => {
    try {
        const file = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!file) {
            const error = new Error('Faça o upload do arquivo!');
            error.statusCode = 422;
            throw error;
        }
        const readableFile = new stream_1.Readable();
        readableFile.push(file.buffer);
        readableFile.push(null);
        const docLines = readline_1.default.createInterface({
            input: readableFile,
        });
        // Extraindo os Dados
        let index = 0;
        for await (let line of docLines) {
            const fields = line.split(',');
            let anoConclusao = fields[0];
            let numeroCarteira = fields[1];
            let nome = fields[2];
            const membro = await membro_1.default.findOne({ numeroCarteira });
            if (membro) {
                membro.anoConlusao = parseInt(anoConclusao);
                membro.dataInicio = new Date(anoConclusao);
                await membro.save();
            }
            // console.log(membro);
            // console.log(index);
            index++;
        }
        res.status(201).json({
            msg: 'Sucesso',
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAnoConclusaoFromExcel = getAnoConclusaoFromExcel;
// Aprova um membro como membro na ordem
const approveFinal = async (req, res, next) => {
    try {
        const { membroId, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const userAdmin = await user_1.default.findById(userId);
        if (!userAdmin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error(`Membro não encontrado`);
            error.statusCode = 422;
            throw error;
        }
        if (membro.approved) {
            const error = new Error(`Membro já foi aprovado`);
            error.statusCode = 422;
            throw error;
        }
        // if (membro.status !== 'Aprovado-Presidente') {
        //   const error: IError = new Error(
        //     `Inválido para aprovação em ${membro.status}`,
        //   );
        //   error.statusCode = 422;
        //   throw error;
        // }
        const dadosPessoais = await dados_pessoais_1.default.findById(membro.dadosPessoais);
        const foundUserWithEmail = await user_1.default.findOne({
            email: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
        });
        if (foundUserWithEmail) {
            const error = new Error(`Foi encontrado um utilizador usando o email '${dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email}'. Por favor contacte o suporte!`);
            error.statusCode = 422;
            throw error;
        }
        const codigoVerificao = (0, verification_code_1.default)(6);
        const password = 'CNPUSER' + (0, verification_code_1.default)(6) + 'OFA';
        const hashPassword = await bcryptjs_1.default.hash(password, 12);
        membro.dataInicio = new Date((0, main_1.getAngolaTime)());
        membro.aprovadoPor = userAdmin;
        membro.approved = true;
        membro.status = 'Activo';
        await membro.save();
        // Cria SituacaoFinanceira
        const date = new Date((0, main_1.getAngolaTime)());
        const ano = date.getFullYear();
        const mesInicio = date.getMonth() + 1;
        const situacoesFinaceiras = await (0, financa_1.createManySF)(ano, mesInicio, membro.id);
        // Fim SituacaoFinanceira
        // Cria o user do membro
        const user = new user_1.default({
            email: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
            tipo: 'Membro',
            password: hashPassword,
            codigoVerificao,
            dadosPessoais,
            membro: membro,
        });
        await user.save();
        // Fim cria o user do membro
        // Cria o historico da carteira
        const bastionario = await user_1.default.findOne({ funcao: 'Bastionário' });
        const dataEmissao = new Date((0, main_1.getAngolaTime)());
        await carteira_1.default.create({
            numeroCarteira: membro.numeroCarteira,
            membro,
            dataEmissao,
            dataExpiracao: (0, date_fns_1.addYears)(dataEmissao, 1),
            por: user,
            bastionario,
        });
        // Fim cria o historico da carteira
        if (userAdmin) {
            let action = `Aprovou membro ${membro.numeroCarteira}`;
            await (0, main_1.createHistoricoActividade)(action, 'Membro', membro.id, userAdmin);
        }
        await postmark_1.default.sendEmail({
            To: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email,
            From: process.env.SENDER_EMAIL,
            Subject: 'Aprovação como Membro',
            HtmlBody: `<h1>Bem vindo a Ordem dos Farmacêuticos de Angola (OFA)</h1>
        <p>
          Parabéns, foi ${(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.genero) === 'M' ? 'Aprovado' : 'Aprovada'} como Membro Ordem dos Farmacêuticos de Angola (OFA)
          com o número de carteira <b>${membro.numeroCarteira}</b>, na plataforma CNP (Carteira Nacional Profissional).
        </p>

        <h3>Dados de Acesso</h3>

        <p>Número de carteira: ${membro.numeroCarteira}</p>
       
        <p>User: ${dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.email}</p>

        <p>Senha: ${password}</p>

        <p><b>NOTA:</b>Senha gerada automaticamente poderá alterar na plataforma!</p>

        <p>Este e-mail foi gerado automaticamente pela plataforma <b>CNP - CRL</b></p>
      `,
            MessageStream: 'outbound',
        });
        res.status(201).json({
            msg: 'Sucesso!',
            membro,
            user,
            situacoesFinaceiras,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.approveFinal = approveFinal;
// Controller para editar documento
const editDoc = async (req, res, next) => {
    try {
        let { userId, membroId } = req.body;
        const nomeDoc = req.body.nomeDoc;
        const file = req.file;
        let admin;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!file) {
            const error = new Error(`Por favor, carregue um arquivo!`);
            error.statusCode = 422;
            throw error;
        }
        if (!membro_docs_1.membroAllowedDocs.includes(nomeDoc)) {
            const error = new Error(`Não existe documento com o nome ${nomeDoc}`);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            const admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error(`Admin não encontrado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        const membro = await membro_1.default.findById(membroId);
        if (!membro) {
            const error = new Error(`Estagiário não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        file.filename = (0, file_1.generateFileName)(file);
        await (0, aws_1.uploadFile)(file);
        // if (membro.docs) {
        //   if (membro.docs[nomeDoc]) {
        //     await deleteFile(membro.docs[nomeDoc]!);
        //   }
        // }
        membro.docs[nomeDoc] = file.filename;
        await membro.save();
        membro.docs[nomeDoc] = await (0, aws_1.getURL)(membro.docs[nomeDoc]);
        if (admin) {
            let action = `Editou o documento ${nomeDoc}`;
            await (0, main_1.createHistoricoActividade)(action, 'Membro', membro.id, admin);
        }
        res.status(201).json({ msg: 'Sucesso', membro: membro });
    }
    catch (err) {
        next(err);
    }
};
exports.editDoc = editDoc;
// #######################################################################################
// NOVAS FUNCIONALIDADES JONILSON
// busca dados pessoais pelo BI
const searchMembroBi = async (req, res, next) => {
    let { bi } = req.params;
    try {
        const verificacao = await dados_pessoais_1.default.findOne({ bi: bi });
        if (!verificacao) {
            const error = new Error(`Usuário não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findOne({ dadosPessoais: verificacao._id });
        if (!(membro === null || membro === void 0 ? void 0 : membro.approved)) {
            const error = new Error(`Este Processo ainda não foi aprovado!`);
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({
            msg: 'Sucesso',
            membro,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.searchMembroBi = searchMembroBi;
const confirmActualizacaoDadosMembro = async (req, res, next) => {
    try {
        let { membroId, dadosPessoaisId } = req.body;
        let user;
        let password;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId);
        const dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
        // const dadosAcademico = await DadosAcademico.findOne({membroId});
        // const dadosInstitucional = await ExperienciaProfissional.findOne({membroId});
        if (membro === null || membro === void 0 ? void 0 : membro.campanha) {
            const error = new Error('Já fez a actualização da campanha! caso desejar fazer mais alguma retificaçäo em seus dados, entra no seu perfil de membro usando as credênçais de acesso que recebeu no seu E-mail.');
            error.statusCode = 422;
            ``;
            throw error;
        }
        if (!membro) {
            const error = new Error('Membro não encontrados!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais) {
            const error = new Error('Dados Pessoais não encontrados!');
            error.statusCode = 422;
            throw error;
        }
        // Verificar se os dados pessoais estao todos completos
        if (dadosPessoais.fotoURL === 'user.png') {
            const error = new Error('Por favor insira uma foto do tipo passe para o teu perfil');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.email) {
            const error = new Error('Por favor insira um email válido nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.nome) {
            const error = new Error('Por favor insira o nome nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.genero) {
            const error = new Error('Por favor insira o gênero nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.estadoCivil) {
            const error = new Error('Por favor insira o estado civil nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.dataNascimento) {
            const error = new Error('Por favor insira a data de nascimento nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.provincia) {
            const error = new Error('Por favor insira a provincia nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.municipio) {
            const error = new Error('Por favor insira o municipio nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.bairro) {
            const error = new Error('Por favor insira o seu bairro nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.provinciaNasc) {
            const error = new Error('Por favor insira a provincia de nascimento nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.municipioNasc) {
            const error = new Error('Por favor insira o municipio de nascimento nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.nacionalidade) {
            const error = new Error('Por favor insira a nacionalidade nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.telefone1) {
            const error = new Error('Por favor insira o contacto nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        if (!dadosPessoais.bi) {
            const error = new Error('Por favor insira o numero de B.I nos seus dados pessoais!');
            error.statusCode = 422;
            throw error;
        }
        // Verificar se os Dados Acadêmicos estao todos completos
        // if (!dadosAcademico.) {
        //   const error: IError = new Error('Por favor insira o numero de B.I nos seus dados pessoais!');
        //   error.statusCode = 422;
        //   throw error;
        // }
        // Verificar se os Dados do Local de Trabalho estao todos completos
        // if (!dadosInstitucional) {
        //   const error: IError = new Error('Por favor insira o numero de B.I nos seus dados pessoais!');
        //   error.statusCode = 422;
        //   throw error;
        // }
        // Verificar se os Documentos estao todos completos
        if (!membro.docs.copiaBI) {
            const error = new Error('Por favor insira uma cópia legivel do bilhete de identidade nos seus documentos!');
            error.statusCode = 422;
            throw error;
        }
        if (!membro.docs.diplomaCertificado) {
            const error = new Error('Por favor insira uma cópia legivel do diploma / certificado nos seus documentos!');
            error.statusCode = 422;
            throw error;
        }
        if (!membro.docs.declaracaoInares) {
            const error = new Error('Por favor insira uma cópia legivel da declaracão do Inares nos seus documentos!');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(dadosPessoais.email)) {
            user = await user_1.default.findOne({ membro: membro === null || membro === void 0 ? void 0 : membro.id });
            if (user) {
                user.email = dadosPessoais.email;
                await user.save();
            }
        }
        password = 'CNPUSER' + (0, verification_code_1.default)(6) + 'CRL';
        const hashPassword = await bcryptjs_1.default.hash(password, 12);
        if (user) {
            user.password = hashPassword;
            await user.save();
        }
        // MARCAR O MEMBRO QUE PARTICIPOU NA CAMPANHA
        if (membro) {
            membro.campanha = true;
            membro.dataCampanha = new Date();
            await membro.save();
        }
        await postmark_1.default.sendEmail({
            To: dadosPessoais.email,
            From: process.env.SENDER_EMAIL,
            Subject: `Conta de Membro`,
            HtmlBody: `<h1>Bem Vindo(a) a  Plataforma </h1>
          <P><b>PARABÉNS,</b></P>
          <P>os seus dados foram actualizados com sucesso!</P>

          <p>A ${dadosPessoais.genero === 'M' ? 'Sr.' : 'Sra.'}  ${dadosPessoais.nome},
          é detentor(a) da Carteira Nº: <b>${membro === null || membro === void 0 ? void 0 : membro.numeroCarteira} </b>.
          Segue a baixo as credenciais de acesso para área de membro na Plataforma
           </p>

          <p>email: ${dadosPessoais.email} | Carteira: ${membro === null || membro === void 0 ? void 0 : membro.numeroCarteira} </p>

          <p>Senha: ${password}</p>

          <p><b>Para uma melhor experiência, baixe o Aplicativo Mobile:</b></p>
          <p><b>Baixe o aplicativo:</b> <a href="https://apps.apple.com/ao/app/cnp-carteira-digital/id6480178712" target="_blank">CNP Carteira Digital Para IPHONE</a></p>
          <p><b>Baixe o aplicativo:</b> <a href="https://play.google.com/store/apps/details?id=com.cnpdigital.cnpao&pli=1" target="_blank">CNP Carteira Digital para ANDROID</a></p>
          
          <p><b>Link do Site:</b> <a href="https://ofa.ao" target="_blank">ofa.ao</a></p>
          
          <p><b>NOTA:</b>Senha gerada automaticamente poderá alterar na plataforma</p>
          <p><i>Este e-mail foi gerado automaticamente pela Plataforma</i></p>
        `,
            MessageStream: 'outbound',
        });
        const emailEnviado = `<h1>Bem Vindo(a) a Plataforma </h1>
    <P><b>PARABÉNS,</b></P>
    <P>os seus dados foram actualizados com sucesso!</P>

    <p>A ${dadosPessoais.genero === 'M' ? 'Sr.' : 'Sra.'}  ${dadosPessoais.nome},
    é detentor(a) da Carteira Nº: <b>${membro === null || membro === void 0 ? void 0 : membro.numeroCarteira} </b>.
    Segue a baixo as credenciais de acesso para área de membro na Plataforma 
     </p>

    <p>email: ${dadosPessoais.email} | Carteira: ${membro === null || membro === void 0 ? void 0 : membro.numeroCarteira} </p>

    <p>Senha: *******</p>

    <p><b>Para uma melhor experiência, baixe o Aplicativo Mobile:</b></p>
    <p><b>Baixe o aplicativo:</b> <a href="https://apps.apple.com/ao/app/cnp-carteira-digital/id6480178712" target="_blank">CNP Carteira Digital Para IPHONE</a></p>
    <p><b>Baixe o aplicativo:</b> <a href="https://play.google.com/store/apps/details?id=com.cnpdigital.cnpao&pli=1" target="_blank">CNP Carteira Digital para ANDROID</a></p>
    
    <p><b>Link do Site:</b> <a href="https://ofa.ao" target="_blank">ofa.ao</a></p>
    
    <p><b>NOTA:</b>Senha gerada automaticamente poderá alterar na plataforma</p>
    <p><i>Este e-mail foi gerado automaticamente pela Plataforma </i></p>
  `;
        res.status(201).json({
            msg: 'Editado com sucesso!',
            emailEnviado,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.confirmActualizacaoDadosMembro = confirmActualizacaoDadosMembro;
// funcao para fazer alteracoes na carteira.
const alteracaoCarteira = async (req, res, next) => {
    try {
        // Buscar todos os membros, mas apenas os que têm um numeroCarteira válido
        const membros = await membro_1.default.find({ numeroCarteira: { $exists: true } });
        let count = 1;
        // Prepare as atualizações em lote
        const bulkOps = [];
        // Iterar sobre cada membro para preparar a atualização
        for (let membro of membros) {
            const numeroCarteira = membro.numeroCarteira;
            // Verificar se o numeroCarteira está no formato esperado
            const regex = /^(\d{3})([A-Za-z]{3})(\d{4})$/;
            const match = numeroCarteira.match(regex);
            if (match) {
                const [_, parte1, parte2, parte3] = match;
                // Montar o novo número de carteira: 0862000OFA
                const novoNumero = `${parte1}${parte3}${parte2}`;
                // Preparar a operação de atualização
                bulkOps.push({
                    updateOne: {
                        filter: { _id: membro._id },
                        update: { $set: { numeroCarteira: novoNumero } },
                    },
                });
                console.log(novoNumero + ' - ' + count);
            }
        }
        // Se houver operações para atualizar, realizar a atualização em massa
        if (bulkOps.length > 0) {
            const result = await membro_1.default.bulkWrite(bulkOps);
            console.log(`Número da carteira de ${result.modifiedCount} membros foi alterado com sucesso!`);
        }
        else {
            console.log('Nenhum membro com número de carteira válido encontrado para atualizar.');
        }
        console.log('Número da carteira de todos os membros foi alterado com sucesso!');
        res.status(201).json({
            msg: 'Editado com sucesso!',
            bulkOps,
        });
    }
    catch (error) {
        next(console.error('Erro ao alterar o número da carteira:', error));
    }
};
exports.alteracaoCarteira = alteracaoCarteira;
// #######################################################################################
// FIM NOVAS FUNCIONALIDADES JONILSON
// Metodo para transitar um membro de uma direccao para outra: OFA para CAPFA e vice versa
const changeDireccao = async (req, res, next) => {
    try {
        const { direccao, membroId, observacao, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!membro_1.membroDireccao.includes(direccao.toUpperCase())) {
            const error = new Error('Direccao inválida!');
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId).populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        membro.direccao = direccao;
        /*
          Atribui o numero o numeroIscricao ao numeroInscricaoBeforeTransition
          Depois gera um novo numero de inscricao seguindo a sequencia da nova direccao
        */
        if (!membro.approved) {
            membro.numeroInscricaoBeforeTransition = membro.numeroInscricao;
            membro.numeroInscricao = await (0, exports.generateMembroInscricao)(direccao);
        }
        membro.dataDespacho = new Date();
        membro.despachoPor = admin;
        await membro.save();
        const dadosPessoais = membro.dadosPessoais;
        if (dadosPessoais)
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
        const obs = await observacao_1.default.create({
            assunto: 'Tansição de Direccão',
            para: membro.id,
            observacao,
            de: userId,
        });
        await (0, main_1.createHistoricoActividade)(`Transitou para ${direccao}`, 'Membro', membro.id, admin, observacao);
        if (dadosPessoais.email) {
            await postmark_1.default.sendEmail({
                To: dadosPessoais.email,
                From: process.env.SENDER_EMAIL,
                Subject: 'Transitação de Direcção',
                HtmlBody: `<h1>Seu processo foi transferido para ${direccao}</h1>
      
          ${!membro.approved
                    ? `<p>Novo número de inscrição: <b>${membro.numeroInscricao}</b></p>`
                    : ''}

          <h3>Observação:</h3>   
          <p>
           ${observacao}
          </p>
  
          <p>Este e-mail foi gerado automaticamente pela plataforma <b>CNP - OFA & CAPFA</b></p>
        `,
                MessageStream: 'outbound',
            });
        }
        res.status(201).json({ msg: 'Sucesso', membro, obs });
    }
    catch (error) {
        next(error);
    }
};
exports.changeDireccao = changeDireccao;
// Metodo para deletar membro - Soft Delete
const deleteMembro = async (req, res, next) => {
    try {
        const { membroId, observacao, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findById(membroId)
            .populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        membro.deletedAt = new Date();
        membro.dataDespacho = new Date();
        membro.despachoPor = admin;
        await membro.save();
        const obs = await observacao_1.default.create({
            assunto: `Exclusão de ${membro.approved ? 'membro' : 'inscrição'}`,
            para: membro.id,
            observacao,
            de: userId,
        });
        await (0, main_1.createHistoricoActividade)(`Excluiu`, 'Membro', membro.id, admin, observacao);
        res.status(204).json({ msg: 'Successo' });
    }
    catch (error) {
        next(error);
    }
};
exports.deleteMembro = deleteMembro;
// Metodo para retaurar membro deletado
const restoreMembro = async (req, res, next) => {
    try {
        const { membroId, observacao, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findOne({ _id: membroId }).setOptions({ overrideDeleted: true })
            .populate({
            path: 'dadosPessoais',
        });
        if (!membro) {
            const error = new Error('Membro não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        membro.deletedAt = null;
        membro.dataDespacho = new Date();
        membro.despachoPor = admin;
        await membro.save();
        const obs = await observacao_1.default.create({
            assunto: `Restauração de ${membro.approved ? 'membro' : 'inscrição'}`,
            para: membro.id,
            observacao,
            de: userId,
        });
        await (0, main_1.createHistoricoActividade)(`Restaurou`, 'Membro', membro.id, admin, observacao);
        res.status(201).json({ msg: 'Sucesso', membro, obs });
    }
    catch (error) {
        next(error);
    }
};
exports.restoreMembro = restoreMembro;
