"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.editCarimbo = exports.editAssinatura = exports.getHonorios = exports.deletePermante = exports.changeFuncionarioStatus = exports.getFuncionario = exports.getFuncionarios = exports.makeMembroAdmin = exports.registerUserAdmin = void 0;
const file_1 = require("../util/file");
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const express_validator_1 = require("express-validator");
const dados_pessoais_1 = __importDefault(require("../models/dados-pessoais"));
const verification_code_1 = __importDefault(require("../util/verification-code"));
const aws_1 = require("../util/aws");
const user_1 = __importStar(require("../models/user"));
const membro_1 = __importDefault(require("../models/membro"));
const pagination_1 = require("../util/pagination");
const postmark_1 = __importDefault(require("../services/postmark"));
// Metodo para registar Funcionario
const registerUserAdmin = async (req, res, next) => {
    try {
        const { nome, genero, dataNascimento, estadoCivil, provincia, municipio, bairro, telefone1, telefone2, email, perfil, 
        // Dados do secretario
        userId, } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        let bi = req.body.bi;
        const foto = req.file;
        if (foto) {
            foto.filename = (0, file_1.generateFileName)(foto);
        }
        else {
            const error = new Error(`Por favor forneça uma foto!`);
            error.statusCode = 422;
            throw error;
        }
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const foundEmail = await dados_pessoais_1.default.findOne({ email: email });
        const foundUserEmail = await user_1.default.findOne({
            email: email,
        });
        if (foundEmail || foundUserEmail) {
            const error = new Error(`O email '${email}' já está sendo usado`);
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(telefone1)) {
            const foundTel1 = await dados_pessoais_1.default.findOne({ telefone1: telefone1 });
            if (foundTel1) {
                const error = new Error(`O número de telefone '${telefone1}' já está sendo`);
                error.statusCode = 422;
                throw error;
            }
        }
        if (Boolean(bi)) {
            bi = bi.toUpperCase();
            const foundBI = await dados_pessoais_1.default.findOne({ bi: bi });
            if (foundBI) {
                const error = new Error(`O número do BI '${bi}' já está sendo usado!`);
                error.statusCode = 422;
                throw error;
            }
        }
        const dadosPessoais = new dados_pessoais_1.default({
            nome,
            genero,
            dataNascimento,
            estadoCivil,
            email,
            telefone1,
            provincia,
            bi,
            perfil: perfil,
            fotoURL: foto.filename,
        });
        if (Boolean(telefone2)) {
            dadosPessoais.telefone2 = telefone2;
        }
        if (Boolean(bairro)) {
            dadosPessoais.bairro = bairro;
        }
        if (Boolean(municipio)) {
            dadosPessoais.municipio = municipio;
        }
        if (Boolean(municipio)) {
            dadosPessoais.municipio = municipio;
        }
        if (Boolean(bi)) {
            dadosPessoais.bi = bi;
        }
        if (Boolean(dataNascimento)) {
            dadosPessoais.dataNascimento = dataNascimento;
        }
        if (Boolean(estadoCivil)) {
            dadosPessoais.estadoCivil = estadoCivil;
        }
        await dadosPessoais.save();
        const password = 'CNPUSER' + (0, verification_code_1.default)(6) + 'OFA';
        const hashPassword = await bcryptjs_1.default.hash(password, 12);
        const user = new user_1.default({
            email: dadosPessoais.email,
            funcao: perfil,
            password: hashPassword,
            codigoVerificao: (0, verification_code_1.default)(6),
            delegacao: dadosPessoais.provincia,
            dadosPessoais,
            isAdmin: true,
            tipo: 'Admin',
        });
        await user.save();
        // Upload da foto
        await (0, aws_1.uploadFile)(foto);
        await postmark_1.default.sendEmail({
            To: dadosPessoais.email,
            From: process.env.SENDER_EMAIL,
            Subject: `Conta CNP Admin - Ordem dos Farmacêuticos de Angola (OFA)`,
            HtmlBody: `<h1>Bem vindo a CNP</h1>
        <p>Parabéns a sua conta como ${perfil} foi criada com sucesso. 
        Com isso terá acesso aos serviços da OFA na plataforma CNP</p>

        <h3>Credenciais</h3>

        <p>User: ${dadosPessoais.email}</p>

        <p>Senha: ${password}</p>

        <p><b>NOTA:</b>Senha gerada automaticamente poderá alterar na plataforma!</p>
      `,
            MessageStream: 'outbound'
        });
        res.status(201).json({
            msg: 'Sucesso',
            user,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.registerUserAdmin = registerUserAdmin;
// Metodo para torna membro Admin
const makeMembroAdmin = async (req, res, next) => {
    try {
        const { dadosPessoaisId, perfil, 
        // Dados do secretario
        userId, } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
        if (!dadosPessoais) {
            const error = new Error(`Dados pessoais não encontrado!`);
            error.statusCode = 422;
            throw error;
        }
        if (perfil === 'Presidente') {
            const error = new Error(`Perfil inválido`);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findOne({ dadosPessoais: dadosPessoaisId });
        if (admin) {
            const error = new Error(`Já é um admin!`);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findOne({ dadosPessoais: dadosPessoaisId });
        if (!membro) {
            const error = new Error(`Não é um membro!`);
            error.statusCode = 422;
            throw error;
        }
        const userMembro = await user_1.default.findOne({ membro: membro.id });
        if (!userMembro) {
            const error = new Error(`User membro não encontrado`);
            error.statusCode = 422;
            throw error;
        }
        if (perfil === 'Vice-Presidente') {
            const vices = await dados_pessoais_1.default.find({ perfil: 'Vice-Presidente' });
            for (let vice of vices) {
                vice.perfil = 'Membro';
                await vice.save();
                const userVice = await user_1.default.findOne({ dadosPessoais: vice.id });
                if (userVice) {
                    userVice.status = 'Inactivo';
                    await userVice.save();
                }
            }
        }
        const user = new user_1.default({
            email: dadosPessoais.email,
            funcao: perfil,
            password: userMembro.password,
            codigoVerificao: userMembro.codigoVerificao,
            dadosPessoais: dadosPessoais._id,
            // tipo: 'Admin',
            isAdmin: true,
        });
        await user.save();
        if (perfil === 'Vice-Presidente') {
            dadosPessoais.perfil = 'Vice-Presidente';
            await dadosPessoais.save();
        }
        await postmark_1.default.sendEmail({
            To: dadosPessoais.email,
            From: process.env.SENDER_EMAIL,
            Subject: `Conta Admin - CPL Digital`,
            HtmlBody: `<h1>Bem vindo a CNP</h1>
        <p>Parabéns a sua conta recebeu privilégio de ${perfil}. 
        Com isso terá acesso aos serviços do Conselho Provincial de Luanda na plataforma CNP</p>

        <h3>Credenciais</h3>

        <p>User: ${dadosPessoais.email}</p>

        <p>Senha: ${userMembro.password}</p>

        <p><b>NOTA:</b>Senha gerada automaticamente poderá alterar na plataforma!</p>
      `,
            MessageStream: 'outbound'
        });
        res.status(201).json({
            msg: 'Sucesso',
            dadosPessoais,
            user,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.makeMembroAdmin = makeMembroAdmin;
// Funcao que busca todos os funcionarios
const getFuncionarios = async (req, res, next) => {
    try {
        const { status, funcao, delegacao } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filter = {
            isAdmin: true,
            funcao: { $ne: 'CNP' }
        };
        if (Boolean(status)) {
            filter.status = status;
        }
        if (Boolean(funcao)) {
            filter.funcao = funcao;
        }
        if (Boolean(delegacao)) {
            filter.delegacao = delegacao;
        }
        const total = await user_1.default.find(filter).count();
        const userAdmins = await user_1.default.find(filter)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'dadosPessoais',
        });
        for (let user of userAdmins) {
            let dadosPessoais = user.dadosPessoais;
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            if (user.assinatura) {
                user.assinatura = await (0, aws_1.getURL)(user.assinatura);
            }
            if (user.carimbo) {
                user.carimbo = await (0, aws_1.getURL)(user.carimbo);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            funcionarios: userAdmins,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getFuncionarios = getFuncionarios;
// Funcao que busca um funcionario pelo Id
const getFuncionario = async (req, res, next) => {
    try {
        const { id } = req.params;
        const userAdmin = await user_1.default.findById(id).populate({
            path: 'dadosPessoais',
        });
        if (!userAdmin) {
            const error = new Error('Funcionário não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        let dadosPessoais = userAdmin.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', funcionario: userAdmin });
    }
    catch (err) {
        next(err);
    }
};
exports.getFuncionario = getFuncionario;
const changeFuncionarioStatus = async (req, res, next) => {
    try {
        const { id, status, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!user_1.UserStatus.includes(status)) {
            const error = new Error('Status inválido!');
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findById(userId);
        if (!user) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const funcionario = await user_1.default.findById(id).populate({
            path: 'dadosPessoais',
        });
        if (!funcionario) {
            const error = new Error('Funciário não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        funcionario.status = status;
        await funcionario.save();
        const dadosPessoais = funcionario.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL);
        }
        res.status(201).json({ msg: 'Sucesso', funcionario });
    }
    catch (error) {
        next(error);
    }
};
exports.changeFuncionarioStatus = changeFuncionarioStatus;
const deletePermante = async (req, res, next) => {
    try {
        const { id } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findById(id);
        const dadosPessoais = await dados_pessoais_1.default.findById(user === null || user === void 0 ? void 0 : user.dadosPessoais.id);
        console.log(dadosPessoais);
        dadosPessoais && (await (0, aws_1.deleteFile)(dadosPessoais.fotoURL));
        res.status(204).json({ msg: 'Deletado com sucesso!' });
    }
    catch (error) {
        next(error);
    }
};
exports.deletePermante = deletePermante;
// Funcao que busca todos os funcionarios Honorios
const getHonorios = async (req, res, next) => {
    try {
        const { status } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObject = { funcao: 'Bastonário' };
        if (Boolean(status)) {
            filterObject.status = status;
        }
        const total = await user_1.default.find(filterObject).count();
        const honorios = await user_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'dadosPessoais',
        });
        for (let user of honorios) {
            let dadosPessoais = user.dadosPessoais;
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        res.status(200).json({
            msg: 'Sucesso',
            honorios,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getHonorios = getHonorios;
//Função para adicionar assinatura de usuario 
const editAssinatura = async (req, res, next) => {
    try {
        const { dadosPessoaisId, userId } = req.body;
        const assinatura = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        let admin;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!assinatura) {
            const error = new Error('Por favor fornceça uma assinatura');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrados!');
                error.statusCode = 422;
                throw error;
            }
            // Depois renomeia e faz o upload
            assinatura.filename = (0, file_1.generateFileName)(assinatura);
            await (0, aws_1.uploadFile)(assinatura);
            admin.assinatura = assinatura.filename;
            await admin.save();
        }
        // let action = 'Editou Assinatura';
        // if (admin) {
        //   await createHistoricoActividade(
        //     action,
        //     'DadosPessoais',
        //     dadosPessoaisId,
        //     admin,
        //   );
        // }
        res.status(201).json({
            msg: 'Editado com sucesso!',
        });
    }
    catch (error) {
        next(error);
    }
};
exports.editAssinatura = editAssinatura;
//Função para adicionar carimbo do sitema a um usuario 
const editCarimbo = async (req, res, next) => {
    try {
        const { dadosPessoaisId, userId } = req.body;
        const carimbo = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        let admin;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!carimbo) {
            const error = new Error('Por favor fornceça um carimbo');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            admin = await user_1.default.findById(userId);
            if (!admin) {
                const error = new Error('Admin não encontrados!');
                error.statusCode = 422;
                throw error;
            }
            // Depois renomeia e faz o upload
            carimbo.filename = (0, file_1.generateFileName)(carimbo);
            await (0, aws_1.uploadFile)(carimbo);
            admin.carimbo = carimbo.filename;
            await admin.save();
        }
        // let action = 'Editou Assinatura';
        // if (admin) {
        //   await createHistoricoActividade(
        //     action,
        //     'DadosPessoais',
        //     dadosPessoaisId,
        //     admin,
        //   );
        // }
        res.status(201).json({
            msg: 'Editado com sucesso!',
        });
    }
    catch (error) {
        next(error);
    }
};
exports.editCarimbo = editCarimbo;
