"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.perfis = void 0;
const mongoose_1 = require("mongoose");
exports.perfis = [
    'Farmacêutico(a)',
    'Bastonário',
    'Vice-Presidente',
    'Secretário(a)',
    'Finança',
    'Transicao',
    'AT',
    'CNP'
];
const assembleiaConstitutivaSchema = new mongoose_1.Schema({
    carteira: {
        type: String,
    },
    nome: {
        type: String,
    },
    genero: {
        type: String,
    },
    estadoCivil: {
        type: String
    },
    dataNascimento: {
        type: String,
    },
    bi: {
        type: String,
        uppercase: true,
    },
    nomePai: {
        type: String,
    },
    nomeMae: {
        type: String,
    },
    email: {
        type: String,
        lowercase: true,
    },
    telefone1: {
        type: String,
    },
    telefone2: {
        type: String,
    },
    // fotoURL: {
    //   type: String,
    //   default: 'user.png'
    // },
    perfil: {
        type: String,
        // enum: perfis
    },
    // Temporario / Remover
    cargo: {
        type: String,
        // enum: perfis
    },
    provincia: {
        type: String,
    },
    municipio: {
        type: String,
    },
    bairro: {
        type: String
    },
    rua: {
        type: String
    },
    provinciaNasc: {
        type: String,
    },
    municipioNasc: {
        type: String,
    },
    nacionalidade: {
        type: String
    },
    numero: {
        type: Number
    },
    presenca: {
        type: Boolean,
    },
    docs: {
        copiaBI: String,
        diplomaCertificado: String,
        copiaReconhecimentoME: String,
    },
}, { timestamps: true });
const AssembleiaConstitutiva = (0, mongoose_1.model)('AssembleiaConstitutiva', assembleiaConstitutivaSchema);
exports.default = AssembleiaConstitutiva;
