"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const participanteSchema = new mongoose_1.Schema({
    nome: {
        type: String,
        required: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
    },
    bi: {
        type: String,
        required: true,
    },
    genero: {
        type: String,
        required: true,
    },
    telefone1: {
        type: String,
        required: true,
    },
    telefone2: {
        type: String,
    },
    categoria: {
        type: String,
        required: true,
    },
    ordem: {
        type: String,
        required: true,
    },
    presenca: {
        type: Boolean,
        required: true,
    },
    provincia: {
        type: String,
        required: true,
    },
    municipio: {
        type: String,
        required: true,
    },
    rua: {
        type: String,
        required: true,
    },
    temasProximosEventos: {
        type: String,
        required: true,
    },
    questoesAdicionais: {
        type: String,
    },
}, { timestamps: true });
const Participante = (0, mongoose_1.model)('Participante', participanteSchema);
exports.default = Participante;
