"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const respostaSchema = new mongoose_1.Schema({
    texto: {
        type: String,
        required: true,
    },
    pergunta: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Pergunta', // Relaciona a resposta à pergunta
        required: true,
    },
    emissor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Participante', // Relaciona a resposta à pergunta
        required: true,
    }
}, { timestamps: true });
respostaSchema.index({ pergunta: 1 }); // Índice para melhorar a consulta
const Resposta = (0, mongoose_1.model)('Resposta', respostaSchema);
exports.default = Resposta;
