"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sfStatus = void 0;
const mongoose_1 = require("mongoose");
exports.sfStatus = ['Nulo', 'Pendente', 'Pago', 'Devendo'];
const situacaoFinanceiraSchema = new mongoose_1.Schema({
    ano: {
        type: Number,
    },
    mes: {
        type: Number,
    },
    status: {
        type: String,
        enum: exports.sfStatus,
        default: 'Devendo'
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    }
}, { timestamps: true });
const SituacaoFinanceira = (0, mongoose_1.model)('SituacaoFinanceira', situacaoFinanceiraSchema);
exports.default = SituacaoFinanceira;
