"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.solicitacaoStatus = void 0;
const mongoose_1 = require("mongoose");
exports.solicitacaoStatus = [
    'Análise',
    'Aprovado',
    'Reprovado',
];
const solicitacaoRenovacaoSchema = new mongoose_1.Schema({
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
    numero: {
        type: Number
    },
    dataDespacho: {
        type: Date
    },
    dataAprovacao: {
        type: Date
    },
    tipo: {
        type: String,
        enum: ['Declaração', 'Carteira']
    },
    efeito: {
        type: String,
    },
    pagamento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Pagamento'
    },
    status: {
        type: String,
        enum: exports.solicitacaoStatus,
        default: 'Análise'
    },
}, { timestamps: true });
const Solicitacao = (0, mongoose_1.model)('Solicitacao', solicitacaoRenovacaoSchema);
exports.default = Solicitacao;
