"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHistoricoLoginMembro = exports.getHistoricoLoginMembros = exports.getHistoricoLoginAdmin = exports.getHistoricoLoginAdmins = exports.checkVerificationCode = exports.requestVerificationCode = exports.editPassword = exports.isLogged = exports.loginMembroMobile = exports.loginMembro = exports.refreshToken = exports.login = void 0;
const dados_pessoais_1 = __importDefault(require("./../models/dados-pessoais"));
const express_validator_1 = require("express-validator");
const bcryptjs_1 = __importDefault(require("bcryptjs"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const user_1 = __importDefault(require("../models/user"));
const aws_1 = require("../util/aws");
const membro_1 = __importDefault(require("../models/membro"));
const historico_login_admin_1 = __importDefault(require("../models/historico-login-admin"));
const historico_login_membro_1 = __importDefault(require("../models/historico-login-membro"));
const pagination_1 = require("../util/pagination");
const validate_url_1 = __importDefault(require("../util/validate-url"));
const verification_code_1 = __importDefault(require("../util/verification-code"));
const main_1 = require("../util/main");
const date_fns_1 = require("date-fns");
const refresh_token_1 = __importDefault(require("../models/refresh-token"));
const postmark_1 = __importDefault(require("../services/postmark"));
/*
  Duracao máxima do link da imagem 6 dias
  o getSignedInURL so permite a duracao ate
  menos de uma semana
*/
const duraction = 3600 * 24 * 6;
// Metodo para fazer login na Ordem Admin
const login = async (req, res, next) => {
    try {
        const { email, password } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const userAgent = req.useragent;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findOne({
            email: email,
        }).populate([
            {
                path: 'membro',
            },
            {
                path: 'dadosPessoais',
            }
        ]);
        if (!user) {
            const error = new Error('Senha ou email inválido!');
            error.statusCode = 422;
            throw error;
        }
        if (user.status !== 'Activo') {
            const error = new Error('Usuário ' + user.status);
            error.statusCode = 422;
            throw error;
        }
        const isEqual = await bcryptjs_1.default.compare(password, user.password);
        if (!isEqual) {
            const error = new Error('Senha ou email inválido!');
            error.statusCode = 422;
            throw error;
        }
        if (!(user === null || user === void 0 ? void 0 : user.isAdmin)) {
            const error = new Error('Conta temporariamente indisponivel. Estamos a fazer alguns ajustes!');
            error.statusCode = 422;
            throw error;
        }
        const dadosPessoais = user.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL, duraction);
        }
        if (user.membro) {
            (0, main_1.getDocsURL)(user.membro);
        }
        const token = jsonwebtoken_1.default.sign({
            email: user.email,
            userId: user._id.toString(),
            perfil: dadosPessoais.perfil,
        }, process.env.JWT_SECRET, { expiresIn: '7d' });
        // Criando historico de login
        const device = {
            browser: userAgent === null || userAgent === void 0 ? void 0 : userAgent.browser,
            version: userAgent === null || userAgent === void 0 ? void 0 : userAgent.version,
            os: userAgent === null || userAgent === void 0 ? void 0 : userAgent.os,
            platform: userAgent === null || userAgent === void 0 ? void 0 : userAgent.platform,
            source: userAgent === null || userAgent === void 0 ? void 0 : userAgent.source,
            isMobile: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isMobile,
            isDesktop: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isDesktop,
            isBot: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isBot,
        };
        let historicoLogin = new historico_login_admin_1.default({
            user: user.id,
            action: 'Login',
            device,
        });
        if ((user.funcao = 'CNP')) {
            historicoLogin.cnp = true;
        }
        await historicoLogin.save();
        const refreshToken = await (0, main_1.generateRefreshToken)(user.id);
        res.status(200).json({
            msg: `Sucesso!`,
            token: token,
            user: user,
            refreshToken,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.login = login;
// Controller para fazer o refreshToken
const refreshToken = async (req, res, next) => {
    var _a;
    try {
        const { refreshToken } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        let token;
        let newRefreshToken;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const foundRefreshToken = await refresh_token_1.default.findById(refreshToken);
        if (!foundRefreshToken) {
            const error = new Error('RefreshToken inválido!');
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findById(foundRefreshToken.user).populate([
            {
                path: 'membro',
                populate: {
                    path: 'dadosPessoais'
                }
            },
            {
                path: 'dadosPessoais',
            }
        ]);
        if ((0, date_fns_1.isAfter)(new Date(), foundRefreshToken.expiresIn)) {
            newRefreshToken = await (0, main_1.generateRefreshToken)(foundRefreshToken.user);
        }
        if (user) {
            const dadosPessoais = user.dadosPessoais;
            if (dadosPessoais) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL, duraction);
                if (dadosPessoais) {
                    dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL, duraction);
                    // Para URL do Membro
                    if ((_a = user === null || user === void 0 ? void 0 : user.membro) === null || _a === void 0 ? void 0 : _a.dadosPessoais) {
                        user.membro.dadosPessoais.fotoURL = dadosPessoais.fotoURL;
                    }
                }
            }
            if (user.assinatura) {
                user.assinatura = await (0, aws_1.getURL)(user.assinatura);
            }
            if (user.carimbo) {
                user.carimbo = await (0, aws_1.getURL)(user.carimbo);
            }
            if (user.membro) {
                (0, main_1.getDocsURL)(user.membro);
            }
            token = jsonwebtoken_1.default.sign({
                email: user.email,
                userId: user._id.toString(),
                perfil: dadosPessoais.perfil,
            }, process.env.JWT_SECRET, { expiresIn: '15s' });
        }
        res.status(200).json({
            msg: `Sucesso!`,
            token: token,
            refreshToken: newRefreshToken,
            user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.refreshToken = refreshToken;
// Metodo para fazer login de membro na web
const loginMembro = async (req, res, next) => {
    var _a;
    try {
        const { email, password } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const userAgent = req.useragent;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findOne({
            email: email,
        }).populate([
            {
                path: 'membro',
                populate: [
                    {
                        path: 'dadosPessoais',
                    },
                ],
            },
        ]);
        if (!(user === null || user === void 0 ? void 0 : user.isAdmin)) {
            const error = new Error('Conta temporariamente indisponivel. Estamos a fazer alguns ajustes!');
            error.statusCode = 422;
            throw error;
        }
        if (!user) {
            const error = new Error('Senha ou email inválido!');
            error.statusCode = 422;
            throw error;
        }
        const isEqual = await bcryptjs_1.default.compare(password, user.password);
        if (!isEqual) {
            const error = new Error('Senha ou email inválido!');
            error.statusCode = 422;
            throw error;
        }
        const membro = user.membro;
        const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL, duraction);
        }
        const token = jsonwebtoken_1.default.sign({
            email: user.email,
            userId: user._id.toString(),
            perfil: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.perfil,
        }, process.env.JWT_SECRET, { expiresIn: '7d' });
        // Criando historico de login
        const device = {
            browser: userAgent === null || userAgent === void 0 ? void 0 : userAgent.browser,
            version: userAgent === null || userAgent === void 0 ? void 0 : userAgent.version,
            os: userAgent === null || userAgent === void 0 ? void 0 : userAgent.os,
            platform: userAgent === null || userAgent === void 0 ? void 0 : userAgent.platform,
            source: userAgent === null || userAgent === void 0 ? void 0 : userAgent.source,
            isMobile: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isMobile,
            isDesktop: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isDesktop,
            isBot: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isBot,
        };
        const historicoLogin = new historico_login_membro_1.default({
            user: user.id,
            action: 'Login',
            device,
        });
        if (((_a = user.membro) === null || _a === void 0 ? void 0 : _a.dadosPessoais.perfil) === 'CNP') {
            historicoLogin.cnp = true;
        }
        await historicoLogin.save();
        res.status(200).json({
            msg: `Sucesso!`,
            token: token,
            user: user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.loginMembro = loginMembro;
// Metodo para fazer login de membro no mobile
const loginMembroMobile = async (req, res, next) => {
    var _a;
    try {
        const { numeroCarteira, password } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const userAgent = req.useragent;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const membro = await membro_1.default.findOne({
            numeroCarteira: numeroCarteira,
        });
        if (!membro) {
            const error = new Error('Carteira ou senha inválida!');
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findOne({ dadosPessoais: membro.dadosPessoais }).populate({
            path: 'membro',
            populate: [
                {
                    path: 'dadosPessoais',
                },
            ],
        });
        if (!user) {
            const error = new Error('Usuário não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const isEqual = await bcryptjs_1.default.compare(password, user.password);
        if (!isEqual) {
            const error = new Error('Carteira ou senha inválida!');
            error.statusCode = 422;
            throw error;
        }
        const m = user.membro;
        const dadosPessoais = m === null || m === void 0 ? void 0 : m.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL, duraction);
        }
        if (membro) {
            // Metodo para gerar URL AWS dos dos documentos
            (0, main_1.getDocsURL)(membro);
        }
        const token = jsonwebtoken_1.default.sign({
            email: user.email,
            userId: user._id.toString(),
            perfil: dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.perfil,
        }, process.env.JWT_SECRET, { expiresIn: '13d' });
        // Criando historico de login
        const device = {
            browser: userAgent === null || userAgent === void 0 ? void 0 : userAgent.browser,
            version: userAgent === null || userAgent === void 0 ? void 0 : userAgent.version,
            os: userAgent === null || userAgent === void 0 ? void 0 : userAgent.os,
            platform: userAgent === null || userAgent === void 0 ? void 0 : userAgent.platform,
            source: userAgent === null || userAgent === void 0 ? void 0 : userAgent.source,
            isMobile: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isMobile,
            isDesktop: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isDesktop,
            isBot: userAgent === null || userAgent === void 0 ? void 0 : userAgent.isBot,
        };
        const historicoLogin = new historico_login_membro_1.default({
            user: user.id,
            action: 'Login',
            device,
            onApp: true,
        });
        if (((_a = user.membro) === null || _a === void 0 ? void 0 : _a.dadosPessoais.perfil) === 'CNP') {
            historicoLogin.cnp = true;
        }
        await historicoLogin.save();
        const refreshToken = await (0, main_1.generateRefreshToken)(user.id);
        res.status(200).json({
            msg: `Sucesso!`,
            token: token,
            refreshToken,
            user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.loginMembroMobile = loginMembroMobile;
const isLogged = async (req, res, next) => {
    var _a;
    try {
        const token = req.body.token;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        let decodedToken;
        decodedToken = jsonwebtoken_1.default.verify(token, process.env.JWT_SECRET);
        if (!decodedToken) {
            const error = new Error('Não autenticado!');
            error.statusCode = 401;
            throw error;
        }
        const user = await user_1.default.findById(decodedToken.userId).populate([
            {
                path: 'membro',
                populate: {
                    path: 'dadosPessoais'
                }
            },
            {
                path: 'dadosPessoais',
            }
        ]);
        if (!user) {
            const error = new Error('Utilizador não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const dadosPessoais = user.dadosPessoais;
        if (dadosPessoais) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL, duraction);
            // Para URL do Membro
            if ((_a = user === null || user === void 0 ? void 0 : user.membro) === null || _a === void 0 ? void 0 : _a.dadosPessoais) {
                user.membro.dadosPessoais.fotoURL = dadosPessoais.fotoURL;
            }
        }
        if (user.assinatura) {
            user.assinatura = await (0, aws_1.getURL)(user.assinatura);
        }
        if (user.carimbo) {
            user.carimbo = await (0, aws_1.getURL)(user.carimbo);
        }
        res.status(201).json({
            msg: `Logado com sucesso!`,
            token: token,
            user: user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.isLogged = isLogged;
// Metodo para alterar a senha
const editPassword = async (req, res, next) => {
    try {
        const { dadosPessoaisId, newPassword, oldPassword, allowedEdit, userId, // userId do Admin
         } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        /*
          Se nao for o admin editando entao
          o campo oldPassword e obrigatorio
        */
        if (!Boolean(oldPassword) &&
            !Boolean(userId) &&
            !Boolean(JSON.parse(allowedEdit))) {
            const error = new Error('O campo oldPassword é obrigatório!');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(userId)) {
            const foundAdmin = await user_1.default.findById(userId);
            if (!foundAdmin) {
                const error = new Error('Admin não encontrado!');
                error.statusCode = 422;
                throw error;
            }
        }
        const dadosPessoais = await dados_pessoais_1.default.findById(dadosPessoaisId);
        if (!dadosPessoais) {
            const error = new Error('DadosPessoais não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const foundMembro = await membro_1.default.findOne({
            dadosPessoais: dadosPessoaisId,
        });
        const user = await user_1.default.findOne({
            email: dadosPessoais.email,
            membro: foundMembro === null || foundMembro === void 0 ? void 0 : foundMembro.id,
        }).populate([
            {
                path: 'membro',
                populate: [
                    {
                        path: 'dadosPessoais',
                    }
                ],
            },
            {
                path: 'dadosPessoais'
            }
        ]);
        if (!user) {
            const error = new Error('Utilizador não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const hashPassword = await bcryptjs_1.default.hash(newPassword, 12);
        if (!Boolean(userId) && !Boolean(JSON.parse(allowedEdit))) {
            const isEqual = await bcryptjs_1.default.compare(oldPassword, user.password);
            if (!isEqual) {
                const error = new Error('Senha antiga errada!');
                error.statusCode = 422;
                throw error;
            }
        }
        user.password = hashPassword;
        await user.save();
        // Se encontrar um user membro
        if (user.tipo === 'Membro') {
            const membro = user.membro;
            if (membro === null || membro === void 0 ? void 0 : membro.dadosPessoais) {
                membro.dadosPessoais.fotoURL = await (0, aws_1.getURL)(membro.dadosPessoais.fotoURL, duraction);
            }
            if (membro) {
                // Metodo para gerar URL AWS dos dos documentos
                (0, main_1.getDocsURL)(membro);
            }
        }
        if (Boolean(userId)) {
            await postmark_1.default.sendEmail({
                To: dadosPessoais.email,
                From: process.env.SENDER_EMAIL,
                Subject: 'Alteração de senha',
                HtmlBody: `<h1>A sua senha foi alterada com sucesso!</h1>
  
          <h3>Dados de Acesso</h3>
  
          <p>User: ${dadosPessoais.email}</p>
  
          <p>Senha: ${newPassword}</p>
  
          <p><b>OBS:</b>Após o login, altere a sua senha na plataforma!</p>
        `,
                MessageStream: 'outbound'
            });
        }
        res.status(201).json({
            msg: `Senha alterada com sucesso!`,
            user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.editPassword = editPassword;
// Metodo para solicitar código de verificacao
const requestVerificationCode = async (req, res, next) => {
    try {
        const { email } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const codigo = (0, verification_code_1.default)(6);
        const date = new Date();
        const dataCV = (0, date_fns_1.addDays)(date, 1);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findOne({
            email: email,
        }).populate({
            path: 'membro',
            populate: {
                path: 'dadosPessoais'
            }
        });
        if (!user) {
            const error = new Error('Utilizador não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (user) {
            user.codigoVerificao = codigo;
            user.dataCV = dataCV;
            await user.save();
        }
        await postmark_1.default.sendEmail({
            To: email,
            From: process.env.SENDER_EMAIL,
            Subject: 'Recuperação de senha',
            HtmlBody: `<h1>Seu codigo de verificação</h1>

          <p>
            O código de verificação enviado tem a duração de 24 horas e não deve ser partilhado!
          </p>
  
          <h2>Código:</h2>
  
          <h3>${codigo}</h3>
  
          <p><i>Este e-mail foi gerado automaticamente pela plataforma CNP</i></p>
        `,
        });
        res.status(201).json({
            msg: `Sucesso!`,
            user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.requestVerificationCode = requestVerificationCode;
// Metodo para validar código de verificacao
const checkVerificationCode = async (req, res, next) => {
    try {
        const { email, codigo } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const date = new Date();
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findOne({
            email: email,
        }).populate('membro');
        if (!user) {
            const error = new Error('Utilizador não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (user) {
            if (user.codigoVerificao !== +codigo) {
                const error = new Error('Código inválido!');
                error.statusCode = 422;
                throw error;
            }
            if ((0, date_fns_1.isAfter)(date, new Date(user.dataCV))) {
                const error = new Error('Código expirado!');
                error.statusCode = 422;
                throw error;
            }
        }
        if (user) {
            if (user.codigoVerificao !== +codigo) {
                const error = new Error('Código inválido!');
                error.statusCode = 422;
                throw error;
            }
            if ((0, date_fns_1.isAfter)(date, new Date(user.dataCV))) {
                const error = new Error('Código expirado!');
                error.statusCode = 422;
                throw error;
            }
        }
        res.status(201).json({
            msg: `Sucesso!`,
            user,
        });
    }
    catch (error) {
        next(error);
    }
};
exports.checkVerificationCode = checkVerificationCode;
// Metodo para pegar os historicos de login dos admin
const getHistoricoLoginAdmins = async (req, res, next) => {
    try {
        let { userId, action, day, month, year } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = {};
        if (Boolean(userId)) {
            const user = await user_1.default.findById(userId);
            if (!user) {
                const error = new Error('Utilizador não encontrado!');
                error.statusCode = 422;
                throw error;
            }
            filterObject.user = userId;
        }
        if (Boolean(action)) {
            const allowedActions = ['Login', 'Logout'];
            if (!allowedActions.includes(action)) {
                const error = new Error('Action inválida!');
                error.statusCode = 422;
                throw error;
            }
            filterObject.action = action;
        }
        if (Boolean(day)) {
            const date = new Date(day);
            const nextDate = new Date(`${date.getFullYear()}-${date.getMonth() + 1}-${date.getDate() + 1}`);
            filterObject.createdAt = { $gte: date, $lte: nextDate };
        }
        const total = await historico_login_admin_1.default.find(filterObject).count();
        const historicoLogins = await historico_login_admin_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'user',
            populate: {
                path: 'dadosPessoais',
            },
        })
            .sort({ createdAt: -1 });
        for (const historico of historicoLogins) {
            const user = historico === null || historico === void 0 ? void 0 : historico.user;
            const dadosPessoais = user === null || user === void 0 ? void 0 : user.dadosPessoais;
            if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL)) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            historicoLogins,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getHistoricoLoginAdmins = getHistoricoLoginAdmins;
// Metodo para pegar o historico de login do admin pelo id
const getHistoricoLoginAdmin = async (req, res, next) => {
    try {
        let { id } = req.params;
        const historicoLogin = await historico_login_admin_1.default.findById(id).populate({
            path: 'user',
            populate: {
                path: 'dadosPessoais',
            },
        });
        const user = historicoLogin === null || historicoLogin === void 0 ? void 0 : historicoLogin.user;
        const dadosPessoais = user === null || user === void 0 ? void 0 : user.dadosPessoais;
        if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL)) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        res.status(200).json({
            msg: 'Sucesso',
            historicoLogin,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getHistoricoLoginAdmin = getHistoricoLoginAdmin;
// Metodo para pegar os historicos de login dos user membros na web
const getHistoricoLoginMembros = async (req, res, next) => {
    try {
        let { userId, action, day, month, year } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = {};
        if (Boolean(userId)) {
            const user = await user_1.default.findById(userId);
            if (!user) {
                const error = new Error('Utilizador não encontrado!');
                error.statusCode = 422;
                throw error;
            }
            filterObject.user = userId;
        }
        if (Boolean(action)) {
            const allowedActions = ['Login', 'Logout'];
            if (!allowedActions.includes(action)) {
                const error = new Error('Action inválida!');
                error.statusCode = 422;
                throw error;
            }
            filterObject.action = action;
        }
        if (Boolean(day)) {
            const date = new Date(day);
            const nextDate = new Date(`${date.getFullYear()}-${date.getMonth() + 1}-${date.getDate() + 1}`);
            filterObject.createdAt = { $gte: date, $lte: nextDate };
        }
        const total = await historico_login_membro_1.default.find(filterObject).count();
        const historicoLogins = await historico_login_membro_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'user',
            populate: {
                path: 'membro',
                populate: {
                    path: 'dadosPessoais',
                },
            },
        })
            .sort({ createdAt: -1 });
        for (const historico of historicoLogins) {
            const user = historico === null || historico === void 0 ? void 0 : historico.user;
            const membro = user === null || user === void 0 ? void 0 : user.membro;
            const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
            if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL)) {
                dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            historicoLogins,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getHistoricoLoginMembros = getHistoricoLoginMembros;
// Metodo para pegar o historico de login do user membro pelo id
const getHistoricoLoginMembro = async (req, res, next) => {
    try {
        let { id } = req.params;
        const historicoLogin = await historico_login_membro_1.default.findById(id).populate({
            path: 'user',
            populate: {
                path: 'membro',
                populate: {
                    path: 'dadosPessoais',
                },
            },
        });
        const user = historicoLogin === null || historicoLogin === void 0 ? void 0 : historicoLogin.user;
        const membro = user === null || user === void 0 ? void 0 : user.membro;
        const dadosPessoais = membro === null || membro === void 0 ? void 0 : membro.dadosPessoais;
        if (dadosPessoais && !(0, validate_url_1.default)(dadosPessoais === null || dadosPessoais === void 0 ? void 0 : dadosPessoais.fotoURL)) {
            dadosPessoais.fotoURL = await (0, aws_1.getURL)(dadosPessoais.fotoURL);
        }
        res.status(200).json({
            msg: 'Sucesso',
            historicoLogin,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getHistoricoLoginMembro = getHistoricoLoginMembro;
