"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCarteira = exports.getCarteiras = void 0;
const carteira_1 = __importDefault(require("../models/carteira"));
const pagination_1 = require("../util/pagination");
const main_1 = require("../util/main");
const aws_1 = require("../util/aws");
// Metodo que busca todas as carteiras
const getCarteiras = async (req, res, next) => {
    try {
        const { numeroCarteira, membroId, expired, por, bastionario, } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObj = {};
        if (Boolean(numeroCarteira)) {
            filterObj.numeroCarteira = numeroCarteira;
        }
        if (Boolean(membroId)) {
            filterObj.membro = membroId;
        }
        if (Boolean(expired)) {
            const currentDate = new Date((0, main_1.getAngolaTime)());
            if (JSON.parse(expired) === true) {
                filterObj.dataExpiracao = { $lt: currentDate };
            }
            else {
                filterObj.dataExpiracao = { $gte: currentDate };
            }
        }
        if (Boolean(por)) {
            filterObj.por = por;
        }
        if (Boolean(bastionario)) {
            filterObj.bastionario = bastionario;
        }
        const total = await carteira_1.default.find(filterObj).count();
        const carteiras = await carteira_1.default.find(filterObj)
            .populate({
            path: 'por',
            populate: 'dadosPessoais',
        })
            .populate({
            path: 'bastionario',
            populate: 'dadosPessoais',
        })
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .sort((0, main_1.sortBy)(req.query.sortBy || 'createdAt:DESC'));
        res.status(200).json({
            msg: 'Sucesso',
            carteiras,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getCarteiras = getCarteiras;
// Metodo que busca pelo id carteira
const getCarteira = async (req, res, next) => {
    var _a, _b, _c;
    try {
        const { id } = req.params;
        const carteira = await carteira_1.default.findById(id)
            .populate({
            path: 'por',
            populate: 'dadosPessoais',
        })
            .populate({
            path: 'bastionario',
            populate: 'dadosPessoais',
        })
            .populate({
            path: 'membro',
            populate: 'dadosPessoais',
        });
        if (!carteira) {
            const error = new Error('Autorização não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if ((_a = carteira.por) === null || _a === void 0 ? void 0 : _a.dadosPessoais) {
            carteira.por.dadosPessoais.fotoURL = await (0, aws_1.getURL)(carteira.por.dadosPessoais.fotoURL);
        }
        if ((_b = carteira.bastionario) === null || _b === void 0 ? void 0 : _b.dadosPessoais) {
            carteira.bastionario.dadosPessoais.fotoURL = await (0, aws_1.getURL)(carteira.bastionario.dadosPessoais.fotoURL);
        }
        if ((_c = carteira === null || carteira === void 0 ? void 0 : carteira.membro) === null || _c === void 0 ? void 0 : _c.dadosPessoais) {
            carteira.membro.dadosPessoais.fotoURL = await (0, aws_1.getURL)(carteira.membro.dadosPessoais.fotoURL);
        }
        res.status(200).json({
            msg: 'Sucesso',
            carteira,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getCarteira = getCarteira;
