"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteEmolumento = exports.getEmolumento = exports.getEmolumentos = exports.createEmolumento = void 0;
const emolumento_1 = __importDefault(require("../models/emolumento"));
const express_validator_1 = require("express-validator");
const user_1 = __importDefault(require("../models/user"));
const main_1 = require("../util/main");
// Controller Para registar Emolumento
const createEmolumento = async (req, res, next) => {
    try {
        let { designacao, valor, tipo, direccao, userId, model } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findById(userId);
        if (!user) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const foundEmolumento = await emolumento_1.default.findOne({
            designacao: designacao,
        });
        if (foundEmolumento) {
            const error = new Error('Emolumento já existe');
            error.statusCode = 422;
            throw error;
        }
        // console.log('Model1: ', model)
        model = (0, main_1.capitalizeFirstCharacter)(model);
        // console.log('Model2: ', model)
        const newEmolumento = new emolumento_1.default({
            designacao,
            valor,
            model,
            tipo,
            direccao,
            admin: userId,
        });
        await newEmolumento.save();
        res
            .status(201)
            .json({ msg: 'Cadastrado com sucesso', emolumento: newEmolumento });
    }
    catch (err) {
        next(err);
    }
};
exports.createEmolumento = createEmolumento;
// Controller Para pegar todos os Emolumentos
const getEmolumentos = async (req, res, next) => {
    try {
        const { model, direccao, tipo } = req.query;
        const filterObject = {};
        if (Boolean(model)) {
            filterObject.model = model;
        }
        if (Boolean(direccao)) {
            filterObject.direccao = direccao;
        }
        if (Boolean(tipo)) {
            filterObject.tipo = tipo;
        }
        const emolumentos = await emolumento_1.default.find(filterObject);
        res.status(200).json({ msg: 'Sucesso', emolumentos });
    }
    catch (err) {
        next(err);
    }
};
exports.getEmolumentos = getEmolumentos;
// Controller que pega um único Emolumento
const getEmolumento = async (req, res, next) => {
    try {
        const { id } = req.params;
        const emolumento = await emolumento_1.default.findById(id);
        res.status(200).json({ msg: 'Sucesso', emolumento });
    }
    catch (err) {
        next(err);
    }
};
exports.getEmolumento = getEmolumento;
// Controller para deletar emolumento
const deleteEmolumento = async (req, res, next) => {
    try {
        const { id, userId } = req.body;
        await emolumento_1.default.findByIdAndRemove(id);
        res.status(204).json({ msg: 'Deletado com sucesso!' });
    }
    catch (err) {
        next(err);
    }
};
exports.deleteEmolumento = deleteEmolumento;
