"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOneEvento = exports.getAllEvento = exports.createEvento = void 0;
const express_validator_1 = require("express-validator");
const evento_1 = __importDefault(require("../models/evento"));
const file_1 = require("../util/file");
const aws_1 = require("../util/aws");
const mongoose_1 = __importDefault(require("mongoose"));
const createEvento = async (req, res, next) => {
    try {
        const { userId, edicao, titulo, descricao, codEvento, } = req.body;
        const imagem = req.file;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const verifyCodEvento = await evento_1.default.findOne({ codEvento });
        const verifyEdicao = await evento_1.default.findOne({ edicao });
        if (verifyCodEvento && verifyEdicao) {
            const error = new Error(`Já foi criado o Envento ${codEvento} - ${edicao} edição! `);
            error.statusCode = 422;
            throw error;
        }
        const evento = new evento_1.default({
            inscricoes: 0,
            edicao,
            titulo,
            descricao,
            codEvento,
            admin: userId,
        });
        if (imagem) {
            imagem.filename = (0, file_1.generateFileName)(imagem);
            evento.imagem = imagem.filename;
            await (0, aws_1.uploadFile)(imagem);
        }
        await evento.save();
        res.status(201).json({
            msg: 'Evento criado com sucesso',
            evento,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createEvento = createEvento;
const getAllEvento = async (req, res, next) => {
    try {
        const eventos = await evento_1.default.find({});
        /*
        .populate({
            path: 'paineisEvento',  // Popula os painéis relacionados ao evento
            populate: [
                { path: 'painel', model: 'Painel' },  // Popula os detalhes do Painel dentro de PainelEvento
                { path: 'temas', model: 'Tema' },     // Popula os Temas específicos do Painel
            ],
        })
        .populate({
            path: 'inqueritos',
            populate: [
                { path: 'perguntas', model: 'Perguntas' },
            ],
        })
        */
        if (eventos.length === 0) {
            return res.status(404).json({
                success: false,
                eventos
            });
        }
        res.status(200).json({
            success: true,
            eventos
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAllEvento = getAllEvento;
const getOneEvento = async (req, res, next) => {
    try {
        const id = req.params.id;
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (validId) {
            const evento = await evento_1.default.findOne({ _id: id });
            if (!evento) {
                return res.status(404).json({
                    success: false,
                    evento
                });
            }
            res.status(200).json({
                success: true,
                evento
            });
        }
        else {
            return res.status(400).json({
                success: false,
                message: 'Id inválido.'
            });
        }
    }
    catch (err) {
        next(err);
    }
};
exports.getOneEvento = getOneEvento;
