"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSaida = exports.getSaidas = exports.createSaida = exports.getFecho = exports.getFechos = void 0;
const express_validator_1 = require("express-validator");
const fecho_1 = __importDefault(require("../models/fecho"));
const saida_1 = __importDefault(require("../models/saida"));
const user_1 = __importDefault(require("../models/user"));
const aws_1 = require("../util/aws");
const pagination_1 = require("../util/pagination");
// Controller que busca fechos em geral dos membro
const getFechos = async (req, res, next) => {
    try {
        let { ano, mes } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 48;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        let filterObject = {};
        if (Boolean(ano)) {
            filterObject.ano = ano;
        }
        if (Boolean(mes)) {
            filterObject.mes = mes;
        }
        const total = await fecho_1.default.find(filterObject).count();
        let fechos = await fecho_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .sort({ ano: -1, mes: 1 });
        res.status(200).json({
            msg: 'Sucesso',
            fechos: fechos,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getFechos = getFechos;
// Controller para buscar fecho pelo id
const getFecho = async (req, res, next) => {
    try {
        const { id } = req.params;
        const fecho = await fecho_1.default.findById(id);
        if (!fecho) {
            const error = new Error('Fecho não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        res.status(200).json({ msg: 'Sucesso', fecho });
    }
    catch (err) {
        next(err);
    }
};
exports.getFecho = getFecho;
// Controller Para registar Saida
const createSaida = async (req, res, next) => {
    try {
        let { valor, descricao, tipo, funcionarioId, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        const date = new Date();
        const ano = date.getFullYear();
        const mes = date.getMonth() + 1;
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findById(userId);
        if (!user) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        if (Boolean(funcionarioId)) {
            const foundFuncionario = await user_1.default.findById(funcionarioId);
            if (!foundFuncionario) {
                const error = new Error('Funcionário não encontrado!');
                error.statusCode = 422;
                throw error;
            }
        }
        let fecho = await fecho_1.default.findOne({ ano: ano, mes: mes });
        if (!fecho) {
            fecho = await fecho_1.default.create({
                ano,
                mes,
                totalSaida: valor,
                saldo: -valor,
            });
        }
        else {
            fecho.totalSaida += +valor;
            fecho.saldo = fecho.totalEntrada - fecho.totalSaida;
            await fecho.save();
        }
        const saida = new saida_1.default({
            valor,
            tipo,
            descricao,
            admin: userId,
        });
        if (Boolean(funcionarioId)) {
            saida.funcionario = funcionarioId;
        }
        await saida.save();
        res.status(201).json({ msg: 'Sucesso', saida });
    }
    catch (err) {
        next(err);
    }
};
exports.createSaida = createSaida;
// Controller Para pegar todos os Saidas
const getSaidas = async (req, res, next) => {
    var _a, _b, _c, _d;
    try {
        const { tipo, valor } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let perPage = 50;
        let paramPerPage = req.query.perPage;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObject = {};
        if (Boolean(tipo)) {
            filterObject.tipo = tipo;
        }
        if (Boolean(valor)) {
            filterObject.valor = valor;
        }
        const saidas = await saida_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage);
        for (let saida of saidas) {
            if ((_b = (_a = saida.admin) === null || _a === void 0 ? void 0 : _a.dadosPessoais) === null || _b === void 0 ? void 0 : _b.fotoURL) {
                saida.admin.dadosPessoais.fotoURL = await (0, aws_1.getURL)(saida.admin.dadosPessoais.fotoURL);
            }
            if ((_d = (_c = saida === null || saida === void 0 ? void 0 : saida.funcionario) === null || _c === void 0 ? void 0 : _c.dadosPessoais) === null || _d === void 0 ? void 0 : _d.fotoURL) {
                saida.funcionario.dadosPessoais.fotoURL = await (0, aws_1.getURL)(saida.funcionario.dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({ msg: 'Sucesso', saidas });
    }
    catch (err) {
        next(err);
    }
};
exports.getSaidas = getSaidas;
// Controller que pega um único Saida
const getSaida = async (req, res, next) => {
    var _a, _b, _c, _d;
    try {
        const { id } = req.params;
        const saida = await saida_1.default.findById(id);
        if (!saida) {
            const error = new Error('Saída não encontrada');
            error.statusCode = 422;
            throw error;
        }
        if ((_b = (_a = saida.admin) === null || _a === void 0 ? void 0 : _a.dadosPessoais) === null || _b === void 0 ? void 0 : _b.fotoURL) {
            saida.admin.dadosPessoais.fotoURL = await (0, aws_1.getURL)(saida.admin.dadosPessoais.fotoURL);
        }
        if ((_d = (_c = saida === null || saida === void 0 ? void 0 : saida.funcionario) === null || _c === void 0 ? void 0 : _c.dadosPessoais) === null || _d === void 0 ? void 0 : _d.fotoURL) {
            saida.funcionario.dadosPessoais.fotoURL = await (0, aws_1.getURL)(saida.funcionario.dadosPessoais.fotoURL);
        }
        res.status(200).json({ msg: 'Sucesso', saida });
    }
    catch (err) {
        next(err);
    }
};
exports.getSaida = getSaida;
