"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deletePermante = exports.searchByNumber = exports.sendResponse = exports.changeStatus = exports.getReclamacao = exports.getReclamacoes = exports.createReclamacao = void 0;
const reclamacao_1 = __importStar(require("../models/reclamacao"));
const file_1 = require("../util/file");
const express_validator_1 = require("express-validator");
const reclamacao_2 = __importDefault(require("../models/reclamacao"));
const aws_1 = require("../util/aws");
const pagination_1 = require("../util/pagination");
const user_1 = __importDefault(require("../models/user"));
const main_1 = require("../util/main");
const counter_1 = __importDefault(require("../models/counter"));
const postmark_1 = __importDefault(require("../services/postmark"));
// Metodo Para criar participacao
const createReclamacao = async (req, res, next) => {
    try {
        // Anexos
        const { anexo1, anexo2 } = req.files;
        const { nome, email, tel, assunto, descricao } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        // Logica para gerar autoincremento
        const counter = await counter_1.default.findOneAndUpdate({ id: 'ReclamacaoCounter' }, { $inc: { seq: 1 } }, { new: true, upsert: true });
        const numero = counter.seq;
        const reclamacao = new reclamacao_1.default({
            nome,
            email,
            tel,
            assunto,
            descricao,
            numero,
        });
        if (anexo1) {
            anexo1[0].filename = (0, file_1.generateFileName)(anexo1[0]);
            reclamacao.anexo1 = anexo1[0].filename;
            await (0, aws_1.uploadFile)(anexo1[0]);
        }
        if (anexo2) {
            anexo2[0].filename = (0, file_1.generateFileName)(anexo2[0]);
            reclamacao.anexo2 = anexo2[0].filename;
            await (0, aws_1.uploadFile)(anexo2[0]);
        }
        await reclamacao.save();
        if (Boolean(email)) {
            await postmark_1.default.sendEmail({
                To: email,
                From: process.env.SENDER_EMAIL,
                Subject: `Reclamação nº ${reclamacao.numero}`,
                HtmlBody: `<h1>Reclamação enviada com sucesso</h1>
        <p>
          Parabéns as sua Reclamação foi enviada com sucesso, 
          ARMED entrará em contacto em tempo oportuno! 
        </p>
        
        <p><b>Nota:</b> Este e-mail foi gerado automaticamente pela plataforma <b>ARMED</b></p>
      `,
                MessageStream: 'outbound'
            });
        }
        res.status(201).json({
            msg: 'Reclamação enviada com sucesso',
            reclamacao,
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createReclamacao = createReclamacao;
// Metodo que busca todas participacoes
const getReclamacoes = async (req, res, next) => {
    try {
        const status = req.query.status;
        const filterObj = {};
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 50;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        if (Boolean(status)) {
            filterObj.status = status;
        }
        const total = await reclamacao_2.default.find(filterObj).count();
        const reclamacoes = await reclamacao_2.default.find(filterObj)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage);
        for (const participacao of reclamacoes) {
            if (participacao.anexo1) {
                participacao.anexo1 = await (0, aws_1.getURL)(participacao === null || participacao === void 0 ? void 0 : participacao.anexo1);
            }
            if (participacao.anexo2) {
                participacao.anexo2 = await (0, aws_1.getURL)(participacao === null || participacao === void 0 ? void 0 : participacao.anexo2);
            }
        }
        res.status(200).json({
            msg: 'Sucesso',
            reclamacoes,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getReclamacoes = getReclamacoes;
// Metodo que busca reclamacao pelo id
const getReclamacao = async (req, res, next) => {
    var _a, _b;
    try {
        const { id } = req.params;
        const reclamacao = await reclamacao_1.default.findById(id).populate({
            path: 'respostas.admin',
            populate: {
                path: 'dadosPessoais',
            },
        });
        if (!reclamacao) {
            const error = new Error('Reclamação não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (reclamacao.anexo1) {
            reclamacao.anexo1 = await (0, aws_1.getURL)(reclamacao.anexo1);
        }
        if (reclamacao.anexo2) {
            reclamacao.anexo2 = await (0, aws_1.getURL)(reclamacao.anexo2);
        }
        for (let resposta of reclamacao.respostas) {
            if ((_b = (_a = resposta.admin) === null || _a === void 0 ? void 0 : _a.dadosPessoais) === null || _b === void 0 ? void 0 : _b.fotoURL) {
                resposta.admin.dadosPessoais.fotoURL = await (0, aws_1.getURL)(resposta.admin.dadosPessoais.fotoURL);
            }
        }
        res.status(200).json({ msg: 'Sucesso', reclamacao: reclamacao });
    }
    catch (err) {
        next(err);
    }
};
exports.getReclamacao = getReclamacao;
// Metodo para mudar status
const changeStatus = async (req, res, next) => {
    var _a, _b;
    try {
        const { id, status, userId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        if (!reclamacao_1.reclamacaoStatus.includes(status)) {
            const error = new Error('Status inválido!');
            error.statusCode = 422;
            throw error;
        }
        const user = await user_1.default.findById(userId);
        if (!user) {
            const error = new Error('Utilizador não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const reclamacao = await reclamacao_1.default.findById(id);
        if (!reclamacao) {
            const error = new Error('Reclamação não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        reclamacao.status = status;
        reclamacao.dataDespacho = new Date().toISOString();
        await reclamacao.save();
        if (reclamacao.anexo1) {
            reclamacao.anexo1 = await (0, aws_1.getURL)(reclamacao.anexo1);
        }
        if (reclamacao.anexo2) {
            reclamacao.anexo2 = await (0, aws_1.getURL)(reclamacao.anexo2);
        }
        for (let resposta of reclamacao.respostas) {
            if ((_b = (_a = resposta.admin) === null || _a === void 0 ? void 0 : _a.dadosPessoais) === null || _b === void 0 ? void 0 : _b.fotoURL) {
                resposta.admin.dadosPessoais.fotoURL = await (0, aws_1.getURL)(resposta.admin.dadosPessoais.fotoURL);
            }
        }
        res.status(201).json({ msg: 'Sucesso', reclamacao: reclamacao });
    }
    catch (err) {
        next(err);
    }
};
exports.changeStatus = changeStatus;
// Metodo para enviar resposta
const sendResponse = async (req, res, next) => {
    try {
        const { id, userId, content } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const admin = await user_1.default.findById(userId);
        if (!admin) {
            const error = new Error('Admin não encontrado!');
            error.statusCode = 422;
            throw error;
        }
        const reclamacao = await reclamacao_1.default.findById(id);
        if (!reclamacao) {
            const error = new Error('Reclamação não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        reclamacao.respostas.push({
            admin: userId,
            content: content,
            data: new Date(),
        });
        await reclamacao.save();
        if (reclamacao.anexo1) {
            reclamacao.anexo1 = await (0, aws_1.getURL)(reclamacao.anexo1);
        }
        if (reclamacao.anexo2) {
            reclamacao.anexo2 = await (0, aws_1.getURL)(reclamacao.anexo2);
        }
        reclamacao;
        await (0, main_1.createHistoricoActividade)('Respondeu Reclamação', 'Reclamacao', reclamacao.id, admin);
        await postmark_1.default.sendEmail({
            To: reclamacao.email,
            From: process.env.SENDER_EMAIL,
            Subject: `Reclamação`,
            HtmlBody: `<h1>Resposta à Reclamação Número ${reclamacao.numero}:</h1>
      <p style="font-size: 12pt">${reclamacao.respostas[reclamacao.respostas.length - 1].content}</p>
          `,
            MessageStream: 'outbound'
        });
        res.status(201).json({ msg: 'Sucesso', reclamacao: reclamacao });
    }
    catch (err) {
        next(err);
    }
};
exports.sendResponse = sendResponse;
// Metodo que busca participacao pelo numero
const searchByNumber = async (req, res, next) => {
    try {
        const { numero } = req.body;
        const reclamacao = await reclamacao_1.default.findOne({
            numero: numero,
        }).populate({
            path: 'respostas.admin',
            populate: {
                path: 'dadosPessoais',
            },
        });
        if (!reclamacao) {
            const error = new Error('Reclamação não encontrada!');
            error.statusCode = 422;
            throw error;
        }
        if (reclamacao.anexo1) {
            reclamacao.anexo1 = await (0, aws_1.getURL)(reclamacao.anexo1);
        }
        if (reclamacao.anexo2) {
            reclamacao.anexo2 = await (0, aws_1.getURL)(reclamacao.anexo2);
        }
        res.status(200).json({ msg: 'Sucesso', reclamacao: reclamacao });
    }
    catch (err) {
        next(err);
    }
};
exports.searchByNumber = searchByNumber;
const deletePermante = async (req, res, next) => {
    try {
        const { reclamacaoId } = req.body;
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const participacao = await reclamacao_1.default.findById(reclamacaoId);
        if (!participacao) {
            const error = new Error(`Reclamação não encontrada!`);
            error.statusCode = 422;
            throw error;
        }
        participacao.anexo1 && (await (0, aws_1.deleteFile)(participacao.anexo1));
        participacao.anexo2 && (await (0, aws_1.deleteFile)(participacao.anexo2));
        await reclamacao_2.default.deleteOne({ _id: reclamacaoId });
        res.status(204).json({
            msg: 'Deletado com sucesso',
        });
    }
    catch (error) {
        next(error);
    }
};
exports.deletePermante = deletePermante;
