"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteTema = exports.getOneTema = exports.getAllTemas = exports.createTema = void 0;
const express_validator_1 = require("express-validator");
const tema_1 = __importDefault(require("../models/tema"));
const mongoose_1 = __importDefault(require("mongoose"));
const createTema = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const { titulo } = req.body;
        const verifyTema = await tema_1.default.findOne({ titulo });
        if (verifyTema) {
            const error = new Error(`O Tema ${verifyTema.titulo} já foi criado! `);
            error.statusCode = 422;
            throw error;
        }
        const tema = new tema_1.default({
            titulo
        });
        await tema.save();
        res.status(201).json({
            msg: 'Tema criado com sucesso',
            tema
        });
    }
    catch (err) {
        next(err);
    }
};
exports.createTema = createTema;
const getAllTemas = async (req, res, next) => {
    try {
        const temas = await tema_1.default.find({});
        if (temas.length === 0) {
            return res.status(404).json({
                success: false,
                temas
            });
        }
        res.status(200).json({
            success: true,
            temas
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getAllTemas = getAllTemas;
const getOneTema = async (req, res, next) => {
    try {
        const id = req.params.id;
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (validId) {
            const tema = await tema_1.default.findOne({ _id: id });
            if (!tema_1.default) {
                return res.status(404).json({
                    success: false,
                    tema
                });
            }
            res.status(200).json({
                success: true,
                tema
            });
        }
        else {
            return res.status(400).json({
                success: false,
                message: 'Id inválido.'
            });
        }
    }
    catch (err) {
        next(err);
    }
};
exports.getOneTema = getOneTema;
const deleteTema = async (req, res, next) => {
    try {
        const errors = (0, express_validator_1.validationResult)(req);
        if (!errors.isEmpty()) {
            const error = new Error(errors.array()[0].msg);
            error.statusCode = 422;
            throw error;
        }
        const id = req.params.id;
        // Verifica se o id é válido
        const validId = mongoose_1.default.Types.ObjectId.isValid(id) ? id : null;
        if (!validId) {
            return res.status(400).json({
                success: false,
                message: 'ID inválido.',
            });
        }
        // Busca o Tema para garantir que ele existe
        const tema = await tema_1.default.findById(id);
        if (!tema) {
            return res.status(404).json({
                success: false,
                message: 'Tema não encontrado.',
            });
        }
        // Deleta o Tema
        await tema_1.default.findByIdAndDelete(id);
        res.status(200).json({
            success: true,
            message: `Tema ${tema.titulo} deletado com sucesso.`,
        });
    }
    catch (err) {
        next(err); // Passa o erro para o middleware de erro
    }
};
exports.deleteTema = deleteTema;
