"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getReferencia = void 0;
const pagination_1 = require("../util/pagination");
const referencia_1 = __importDefault(require("../models/referencia"));
const getReferencia = async (req, res, next) => {
    try {
        const { emolumentoId, dadosPessoaisId, dataReferencia } = req.query;
        const page = (0, pagination_1.getPage)(req.query.page);
        let paramPerPage = req.query.perPage;
        let perPage = 10;
        if (paramPerPage) {
            perPage = +paramPerPage;
        }
        const filterObject = {};
        if (Boolean(emolumentoId)) {
            filterObject.emolumento = emolumentoId;
        }
        if (Boolean(dadosPessoaisId)) {
            filterObject.dadosPessoais = dadosPessoaisId;
        }
        if (Boolean(dataReferencia)) {
            filterObject.updatedAt = { $lte: dataReferencia };
        }
        const total = await referencia_1.default.find(filterObject).count();
        const referencias = await referencia_1.default.find(filterObject)
            .skip((0, pagination_1.skip)(page, perPage))
            .limit(perPage)
            .populate({
            path: 'dadosPessoais'
        });
        res.status(200).json({
            msg: 'Sucesso',
            referencias,
            ...(0, pagination_1.paginationResult)(total, page, perPage),
        });
    }
    catch (err) {
        next(err);
    }
};
exports.getReferencia = getReferencia;
