"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const isAuthMiddleware = (req, res, next) => {
    const authHeader = req.get('Authorization');
    if (!authHeader) {
        const error = new Error('Não autenticado');
        error.statusCode = 401;
        throw error;
    }
    const token = authHeader.split(' ')[1];
    if (token !== process.env.SERVER_API_TOKEN) {
        try {
            jsonwebtoken_1.default.verify(token, process.env.JWT_SECRET);
        }
        catch (error) {
            next(error);
        }
    }
    next();
};
exports.default = isAuthMiddleware;
