"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.perfis = void 0;
const mongoose_1 = require("mongoose");
exports.perfis = [
    'Farmacêutico(a)',
    'Bastonário',
    'Coordenadora',
    'Vice-Presidente',
    'Secretário(a)',
    'Finança',
    'Transicao',
    'AT',
    'CNP'
];
const DadosPessoaisSchema = new mongoose_1.Schema({
    nome: {
        type: String,
    },
    genero: {
        type: String,
    },
    estadoCivil: {
        type: String
    },
    dataNascimento: {
        type: String,
    },
    bi: {
        type: String,
        uppercase: true,
    },
    dataEmissaoBi: {
        type: String,
    },
    nomePai: {
        type: String,
    },
    nomeMae: {
        type: String,
    },
    email: {
        type: String,
        lowercase: true,
    },
    telefone1: {
        type: String,
    },
    telefone2: {
        type: String,
    },
    fotoURL: {
        type: String,
        default: 'user.png'
    },
    perfil: {
        type: String,
        enum: exports.perfis
    },
    // Temporario / Remover
    cargo: {
        type: String,
        enum: exports.perfis
    },
    provincia: {
        type: String,
    },
    municipio: {
        type: String,
    },
    bairro: {
        type: String
    },
    rua: {
        type: String
    },
    provinciaNasc: {
        type: String,
    },
    municipioNasc: {
        type: String,
    },
    nacionalidade: {
        type: String
    },
}, { timestamps: true });
const DadosPessoais = (0, mongoose_1.model)('DadosPessoais', DadosPessoaisSchema);
exports.default = DadosPessoais;
