"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const docsUpload = new mongoose_1.Schema({
    anexo: {
        type: String,
    },
    tipoFile: {
        type: String,
        enum: ['Decreto', 'Despacho', 'Requerimento', 'Modelo', 'Requisitos', 'Manual', 'Lei', 'Outros'],
    },
    nomeFile: {
        type: String,
    },
    descricao: {
        type: String,
    },
    status: {
        type: String,
        enum: ['Activo', 'Inactivo'],
        default: 'Activo'
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'User'
    },
    dataDespacho: {
        type: Date,
        default: new Date(),
    }
}, { timestamps: true });
const DocsUpload = (0, mongoose_1.model)('DocsUpload', docsUpload);
exports.default = DocsUpload;
