"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const eventoSchema = new mongoose_1.Schema({
    edicao: {
        type: Number,
    },
    inscricoes: {
        type: Number,
    },
    titulo: {
        type: String,
    },
    descricao: {
        type: String,
    },
    codEvento: {
        type: String,
    },
    imagem: {
        type: String,
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    inqueritos: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Inquerito',
        },
    ],
    paineisEvento: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'PainelEvento', // Referência ao relacionamento PainelEvento
        },
    ],
    participantes: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Participante', // Referência ao relacionamento Participante
        },
    ],
}, { timestamps: true });
const Evento = (0, mongoose_1.model)('Evento', eventoSchema);
exports.default = Evento;
