"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.pagamentoTipo = exports.pagamentoStatus = void 0;
const mongoose_1 = require("mongoose");
exports.pagamentoStatus = ['Pendente', 'Aprovado', 'Expirado'];
exports.pagamentoTipo = ['Entrada', 'Saída'];
const pagamentoSchema = new mongoose_1.Schema({
    valorPagar: {
        type: String,
    },
    valorPago: {
        type: String,
    },
    comprovativo: {
        type: String,
    },
    numeroTransacao: {
        type: String,
    },
    mes: {
        type: Number,
    },
    ano: {
        type: Number,
    },
    dataOperacao: {
        type: Date,
    },
    dataConfirmacao: {
        type: Date,
    },
    status: {
        type: String,
        enum: exports.pagamentoStatus,
        default: 'Pendente',
    },
    emolumento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Emolumento',
    },
    entidade: {
        type: Number,
        default: 10160
    },
    ref: {
        type: Number
    },
    referencia: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Referencia'
    },
    pagamentoReferencia: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'PagamentoReferencia',
    },
    dadosPessoais: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'DadosPessoais',
    },
    membro: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Membro',
    },
    costumFields: {
        type: Object,
        default: {},
    },
    aprovadoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    admin: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    tipo: {
        type: String,
        enum: exports.pagamentoTipo,
        default: 'Entrada'
    },
}, { timestamps: true });
const Pagamento = (0, mongoose_1.model)('Pagamento', pagamentoSchema);
exports.default = Pagamento;
