"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const mongoose_1 = require("mongoose");
const painelEventoSchema = new mongoose_1.Schema({
    evento: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Evento', // Referência ao Evento
        required: true,
    },
    painel: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'Painel', // Referência ao Painel
        required: true,
    },
    temas: [
        {
            type: mongoose_1.Schema.Types.ObjectId,
            ref: 'Tema', // Referência a muitos Temas, específicos para este evento
        },
    ],
}, { timestamps: true });
const PainelEvento = (0, mongoose_1.model)('PainelEvento', painelEventoSchema);
exports.default = PainelEvento;
