"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.participacaoStatus = void 0;
const mongoose_1 = require("mongoose");
exports.participacaoStatus = [
    'Análise',
    'Analisado-Secretaria',
    'Analisado-AT',
    'Concluído',
];
const participacaoSchema = new mongoose_1.Schema({
    nome: String,
    email: String,
    tel: String,
    assunto: String,
    descricao: String,
    numero: Number,
    anexo1: String,
    anexo2: String,
    status: {
        type: String,
        enum: exports.participacaoStatus,
        default: 'Análise',
    },
    dataDespacho: String,
    despachoPor: {
        type: mongoose_1.Schema.Types.ObjectId,
        ref: 'UserAdmin',
    },
    respostas: [
        {
            admin: {
                type: mongoose_1.Schema.Types.ObjectId,
                ref: 'UserAdmin',
            },
            content: {
                type: String
            },
            data: {
                type: Date
            }
        },
    ],
}, { timestamps: true });
const Participacao = (0, mongoose_1.model)('Participacao', participacaoSchema);
exports.default = Participacao;
